/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import org.apache.torque.generator.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHelper {
    private ClassHelper() {
    }

    public static Object getInstance(String className, Class<?> isInstanceOf) throws ConfigurationException {
        Object result;
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            result = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("The class " + className + " could not be found.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Instantiating " + className + " is not allowed", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("The class " + className + " has no standard constructor.", e);
        }
        if (isInstanceOf != null && !isInstanceOf.isInstance(result)) {
            throw new ConfigurationException("Classes with class : " + className + " are not instances of " + isInstanceOf.getName());
        }
        return result;
    }
}

