package org.apache.torque.templates.platform;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SizedForBitDataSqlType;
import org.apache.torque.templates.typemapping.SqlType;

/**
 * Derby Platform implementation.
 *
 * @author <a href="mailto:johnnymac@tiscali.be">Johnny Macchione</a>
 * @author <a href="mailto:Monroe@DukeCE.com">Greg Monroe</a>
 * @version $Id: PlatformDerbyImpl.java 1437738 2013-01-23 21:20:19Z tfischer $
 */
public class PlatformDerbyImpl extends PlatformDefaultImpl
{

    /**
     * Default constructor.
     */
    public PlatformDerbyImpl()
    {
        super();
        initialize();
    }

    /**
     * Initializes db specific domain mapping.
     */
    private void initialize()
    {
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARCHAR,
                new SqlType("LONG VARCHAR"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.VARBINARY,
                new SizedForBitDataSqlType("VARCHAR", "32672"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.BINARY,
                new SizedForBitDataSqlType("CHAR", "1"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARBINARY,
                new SqlType("LONG VARCHAR FOR BIT DATA"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.LONGVARCHAR,
                new SqlType("LONG VARCHAR"));
        setSchemaTypeToSqlTypeMapping(
                SchemaType.TINYINT,
                new SqlType("SMALLINT"));
    }

    /**
     * @see Platform#getAutoIncrement(
     */
    @Override
    public String getAutoIncrement()
    {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    /**
     * @see Platform#hasScale(String)
     */
    @Override
    public boolean hasScale(String sqlType)
    {
        return "NUMERIC".equals(sqlType) || "DECIMAL".equals(sqlType);
    }

    /**
     * @see Platform#hasSize(String)
     */
    @Override
    public boolean hasSize(String sqlType)
    {
        return "NUMERIC".equals(sqlType) || "DECIMAL".equals(sqlType)
            || "VARCHAR".equals(sqlType) || "CHAR".equals(sqlType)
            || "BINARY".equals(sqlType) || "VARBINARY".equals(sqlType)
            || "BLOB".equals(sqlType) || "CLOB".equals(sqlType);
    }

    @Override
    protected boolean escapeBackslashes()
    {
        return false;
    }
}
