/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.component.window;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.api.config.JsfModuleConfig;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindow;

@FacesRenderer(componentFamily="javax.faces.Output", rendererType="org.apache.deltaspike.DisableClientWindow")
public class DisableClientWindowHtmlRenderer
extends Renderer {
    private volatile Boolean initialized;
    private ClientWindow clientWindow;
    private JsfModuleConfig jsfModuleConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.lazyInit();
        boolean dsClientWindowRenderModeEnabled = this.clientWindow.isClientWindowRenderModeEnabled(context);
        boolean jsfClientWindowRenderModeEnabled = false;
        if (this.jsfModuleConfig.isJsf22Available() && context.getExternalContext().getClientWindow() != null) {
            jsfClientWindowRenderModeEnabled = context.getExternalContext().getClientWindow().isClientWindowRenderModeEnabled(context);
        }
        try {
            if (dsClientWindowRenderModeEnabled) {
                this.clientWindow.disableClientWindowRenderMode(context);
            }
            if (jsfClientWindowRenderModeEnabled) {
                context.getExternalContext().getClientWindow().disableClientWindowRenderMode(context);
            }
            super.encodeChildren(context, component);
        }
        finally {
            if (dsClientWindowRenderModeEnabled) {
                this.clientWindow.enableClientWindowRenderMode(context);
            }
            if (jsfClientWindowRenderModeEnabled) {
                context.getExternalContext().getClientWindow().enableClientWindowRenderMode(context);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    protected synchronized void init() {
        if (this.initialized == null) {
            this.clientWindow = (ClientWindow)BeanProvider.getContextualReference(ClientWindow.class, (Annotation[])new Annotation[0]);
            this.jsfModuleConfig = (JsfModuleConfig)BeanProvider.getContextualReference(JsfModuleConfig.class, (Annotation[])new Annotation[0]);
            this.initialized = true;
        }
    }
}

