/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ViewConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.ClassDeactivator;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.impl.config.view.DefaultFolderConfigDescriptor;

public class ViewConfigPathValidator
implements ServletContextListener,
Deactivatable {
    private static final Logger LOGGER = Logger.getLogger(ViewConfigPathValidator.class.getName());

    public void contextInitialized(ServletContextEvent sce) {
        if (ClassDeactivationUtils.isActivated(this.getClass())) {
            ViewConfigResolver viewConfigResolver;
            try {
                viewConfigResolver = (ViewConfigResolver)BeanProvider.getContextualReference(ViewConfigResolver.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Container issue detected -> can't validate view-configs. This exception is usually the effect (but not the reason) of a failed startup. You can deactivate " + this.getClass().getName() + " via a custom " + ClassDeactivator.class.getName() + " to verify it.", e);
                return;
            }
            ArrayList<String> supportedExtensions = new ArrayList<String>();
            supportedExtensions.add("xhtml");
            supportedExtensions.add("jsp");
            this.validateViewConfigPaths(sce, viewConfigResolver, supportedExtensions);
        }
    }

    protected void validateViewConfigPaths(ServletContextEvent sce, ViewConfigResolver viewConfigResolver, List<String> supportedExtensions) {
        for (ConfigDescriptor configDescriptor : viewConfigResolver.getConfigDescriptors()) {
            try {
                String viewId;
                String extension;
                if (configDescriptor instanceof ViewConfigDescriptor && !supportedExtensions.contains(extension = (viewId = ((ViewConfigDescriptor)configDescriptor).getViewId()).substring(viewId.lastIndexOf(46) + 1)) || this.isValidPath(sce, configDescriptor)) continue;
                if (configDescriptor instanceof DefaultFolderConfigDescriptor && !configDescriptor.getConfigClass().isAnnotationPresent(Folder.class)) {
                    LOGGER.fine(configDescriptor.getConfigClass().getName() + " looks like a marker interface only used for providing meta-data, because the path " + configDescriptor.getPath() + " doesn't exist and the config-class isn't annotated with " + Folder.class.getName());
                    continue;
                }
                throw new IllegalStateException("path '" + configDescriptor.getPath() + "' is missing, but mapped by: " + configDescriptor.getConfigClass().getName());
            }
            catch (Exception e) {
                this.printException(e);
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
    }

    protected boolean isValidPath(ServletContextEvent sce, ConfigDescriptor configDescriptor) {
        try {
            return sce.getServletContext().getResource(configDescriptor.getPath()) != null;
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }

    protected void printException(Exception e) {
        LOGGER.log(Level.SEVERE, "invalid view-config found", e);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

