/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import java.text.MessageFormat;
import java.util.List;
import javax.persistence.Query;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;

public abstract class QueryBuilder {
    public static final String QUERY_SELECT = "select e from {0} e";
    public static final String QUERY_COUNT = "select count(e) from {0} e";
    public static final String QUERY_DELETE = "delete from {0} e";
    public static final String ENTITY_NAME = "e";

    public static String selectQuery(String entityName) {
        return MessageFormat.format(QUERY_SELECT, entityName);
    }

    public static String deleteQuery(String entityName) {
        return MessageFormat.format(QUERY_DELETE, entityName);
    }

    public static String countQuery(String entityName) {
        return MessageFormat.format(QUERY_COUNT, entityName);
    }

    public Object executeQuery(CdiQueryInvocationContext context) {
        Object result = this.execute(context);
        if (!this.isUnmappableResult(result) && context.hasQueryInOutMapper()) {
            QueryInOutMapper<?> mapper = context.getQueryInOutMapper();
            if (result instanceof List) {
                return mapper.mapResultList((List)result);
            }
            return mapper.mapResult(result);
        }
        return result;
    }

    protected abstract Object execute(CdiQueryInvocationContext var1);

    private boolean isUnmappableResult(Object result) {
        return result instanceof QueryResult || result instanceof Query;
    }
}

