/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.request;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.literal.DestroyedLiteral;
import org.apache.deltaspike.core.api.literal.InitializedLiteral;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;

@ApplicationScoped
public class JsfRequestBroadcaster
implements Deactivatable {
    @Inject
    private Event<FacesContext> jsfRequestEvent;
    private Annotation initializedAnnotationInstance;
    private Annotation destroyedAnnotationInstance;

    @PostConstruct
    protected void init() {
        Class destroyedAnnotationClass;
        HashMap<String, Class<RequestScoped>> values = new HashMap<String, Class<RequestScoped>>();
        values.put("value", RequestScoped.class);
        Class initializedAnnotationClass = ClassUtils.tryToLoadClassForName((String)"javax.enterprise.context.Initialized");
        if (initializedAnnotationClass != null) {
            this.initializedAnnotationInstance = AnnotationInstanceProvider.of((Class)initializedAnnotationClass, values);
        }
        if ((destroyedAnnotationClass = ClassUtils.tryToLoadClassForName((String)"javax.enterprise.context.Destroyed")) != null) {
            this.destroyedAnnotationInstance = AnnotationInstanceProvider.of((Class)destroyedAnnotationClass, values);
        }
    }

    public void broadcastInitializedJsfRequestEvent(FacesContext facesContext) {
        this.jsfRequestEvent.select(new Annotation[]{new InitializedLiteral()}).fire((Object)facesContext);
        if (this.initializedAnnotationInstance != null) {
            this.jsfRequestEvent.select(new Annotation[]{this.initializedAnnotationInstance}).fire((Object)facesContext);
        }
    }

    public void broadcastDestroyedJsfRequestEvent(FacesContext facesContext) {
        this.jsfRequestEvent.select(new Annotation[]{new DestroyedLiteral()}).fire((Object)facesContext);
        if (this.destroyedAnnotationInstance != null) {
            this.jsfRequestEvent.select(new Annotation[]{this.destroyedAnnotationInstance}).fire((Object)facesContext);
        }
    }
}

