/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.dto.taskInstance.TaskInstanceQueryRequest;
import org.apache.dolphinscheduler.api.dto.taskInstance.TaskInstanceSuccessResponse;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TASK_INSTANCE_TAG")
@RestController
@RequestMapping(value={"/v2/projects/{projectCode}/task-instances"})
public class TaskInstanceV2Controller
extends BaseController {
    @Autowired
    private TaskInstanceService taskInstanceService;

    @Operation(summary="queryTaskListPaging", description="QUERY_TASK_INSTANCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="workflowInstanceId", description="WORKFLOW_INSTANCE_ID", schema=@Schema(implementation=int.class), example="100"), @Parameter(name="workflowInstanceName", description="WORKFLOW_INSTANCE_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="taskName", description="TASK_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="taskCode", description="TASK_CODE", schema=@Schema(implementation=Long.class)), @Parameter(name="executorName", description="EXECUTOR_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="stateType", description="EXECUTION_STATUS", schema=@Schema(implementation=TaskExecutionStatus.class)), @Parameter(name="host", description="HOST", schema=@Schema(implementation=String.class)), @Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="taskExecuteType", description="TASK_EXECUTE_TYPE", schema=@Schema(implementation=int.class), example="STREAM"), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class), example="1"), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class), example="20")})
    @GetMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_LIST_PAGING_ERROR)
    public Result<PageInfo<TaskInstance>> queryTaskListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, TaskInstanceQueryRequest taskInstanceQueryReq) {
        this.checkPageParams(taskInstanceQueryReq.getPageNo(), taskInstanceQueryReq.getPageSize());
        String searchVal = ParameterUtils.handleEscapes((String)taskInstanceQueryReq.getSearchVal());
        return this.taskInstanceService.queryTaskListPaging(loginUser, projectCode, taskInstanceQueryReq.getWorkflowInstanceId(), taskInstanceQueryReq.getWorkflowInstanceName(), taskInstanceQueryReq.getWorkflowDefinitionName(), taskInstanceQueryReq.getTaskName(), taskInstanceQueryReq.getTaskCode(), taskInstanceQueryReq.getExecutorName(), taskInstanceQueryReq.getStartTime(), taskInstanceQueryReq.getEndTime(), searchVal, taskInstanceQueryReq.getStateType(), taskInstanceQueryReq.getHost(), taskInstanceQueryReq.getTaskExecuteType(), taskInstanceQueryReq.getPageNo(), taskInstanceQueryReq.getPageSize());
    }

    @Operation(summary="savepoint", description="TASK_SAVEPOINT")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="12"))})
    @PostMapping(value={"/{id}/savepoint"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_SAVEPOINT_ERROR)
    public Result<Object> taskSavePoint(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        return this.taskInstanceService.taskSavePoint(loginUser, projectCode, id);
    }

    @Operation(summary="stop", description="TASK_INSTANCE_STOP")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="12"))})
    @PostMapping(value={"/{id}/stop"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_STOP_ERROR)
    public Result<Object> stopTask(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        return this.taskInstanceService.stopTask(loginUser, projectCode, id);
    }

    @Operation(summary="force-success", description="FORCE_TASK_SUCCESS")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class), example="12")})
    @PostMapping(value={"/{id}/force-success"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.FORCE_TASK_SUCCESS_ERROR)
    public TaskInstanceSuccessResponse forceTaskSuccess(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.taskInstanceService.forceTaskSuccess(loginUser, projectCode, id);
        return new TaskInstanceSuccessResponse(Result.success());
    }

    @Operation(summary="queryOneTaskInstance", description="QUERY_ONE_TASK_INSTANCE")
    @Parameters(value={@Parameter(name="taskInstanceId", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=Long.class), example="1234567890")})
    @PostMapping(value={"/{taskInstanceId}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_INSTANCE_ERROR)
    public TaskInstance queryTaskInstanceByCode(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="taskInstanceId") Long taskInstanceId) {
        TaskInstance taskInstance = this.taskInstanceService.queryTaskInstanceById(loginUser, projectCode, taskInstanceId);
        return taskInstance;
    }
}

