/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.endpoint;

import com.aliyuncs.endpoint.EndpointResolver;
import com.aliyuncs.endpoint.EndpointResolverBase;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.aliyuncs.exceptions.ClientException;
import java.util.List;
import java.util.Set;

public class ChainedEndpointResolver
implements EndpointResolver {
    protected List<EndpointResolverBase> endpointResolvers;

    public ChainedEndpointResolver(List<EndpointResolverBase> resolverChain) {
        this.endpointResolvers = resolverChain;
    }

    private void checkProductCode(ResolveEndpointRequest request) throws ClientException {
        boolean productCodeValid = false;
        for (EndpointResolverBase resolver : this.endpointResolvers) {
            if (!resolver.isProductCodeValid(request)) continue;
            productCodeValid = true;
        }
        if (!productCodeValid) {
            throw new ClientException("SDK.EndpointResolvingError", String.format("No endpoint for product '%s'. \nPlease check the product code, or set an endpoint for your request explicitly.\nSee https://www.alibabacloud.com/help/zh/doc-detail/92049.htm\n", request.productCode));
        }
    }

    private void checkRegionId(ResolveEndpointRequest request) throws ClientException {
        boolean regionIdValid = false;
        for (EndpointResolverBase resolver : this.endpointResolvers) {
            if (!resolver.isRegionIdValid(request)) continue;
            regionIdValid = true;
        }
        if (!regionIdValid) {
            throw new ClientException("SDK.EndpointResolvingError", String.format("No such region '%s'. Please check your region ID.", request.regionId));
        }
    }

    private String getAvailableRegionsHint(String productCode) {
        Set<String> availabeRegions = null;
        String availabeRegionsHint = "";
        for (EndpointResolverBase resolver : this.endpointResolvers) {
            availabeRegions = resolver.getValidRegionIdsByProduct(productCode);
            if (availabeRegions == null) continue;
            availabeRegionsHint = "\nOr you can use the other available regions:";
            for (String availabeRegion : availabeRegions) {
                availabeRegionsHint = availabeRegionsHint + " " + availabeRegion;
            }
        }
        return availabeRegionsHint;
    }

    @Override
    public String resolve(ResolveEndpointRequest request) throws ClientException {
        for (EndpointResolverBase resolver : this.endpointResolvers) {
            String endpoint = resolver.resolve(request);
            if (endpoint == null) continue;
            return endpoint;
        }
        this.checkProductCode(request);
        this.checkRegionId(request);
        throw new ClientException("SDK.EndpointResolvingError", String.format("No endpoint in the region '%s' for product '%s'. \nYou can set an endpoint for your request explicitly.%s\nSee https://www.alibabacloud.com/help/zh/doc-detail/92049.htm\n", request.regionId, request.productCode, this.getAvailableRegionsHint(request.productCode)));
    }
}

