/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.h2.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.h2.visitor.H2ASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.List;

public class H2OutputVisitor
extends SQLASTOutputVisitor
implements H2ASTVisitor {
    private static final Log LOG = LogFactory.getLog(H2OutputVisitor.class);

    public H2OutputVisitor(Appendable appender) {
        super(appender, DbType.h2);
    }

    public H2OutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public H2OutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.h2;
    }

    @Override
    public boolean visit(SQLReplaceStatement x) {
        SQLQueryExpr query;
        List<SQLInsertStatement.ValuesClause> valuesClauseList;
        int size;
        this.print0(this.ucase ? "MERGE INTO " : "merge into ");
        this.printTableSourceExpr(x.getTableName());
        List<SQLExpr> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(this.ucase ? " KEY (" : " key (");
            size = columns.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                SQLExpr columnn = columns.get(i);
                this.printExpr(columnn, this.parameterized);
            }
            this.print(')');
        }
        if (!(valuesClauseList = x.getValuesList()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            size = valuesClauseList.size();
            if (size == 0) {
                this.print0("()");
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print0(", ");
                    }
                    this.visit(valuesClauseList.get(i));
                }
            }
        }
        if ((query = x.getQuery()) != null) {
            this.visit(query);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        this.printUcase("CREATE SCHEMA ");
        if (x.isIfNotExists()) {
            this.printUcase("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        this.printCreateTable(x, true);
        return false;
    }

    @Override
    protected void printTableElements(List<SQLTableElement> tableElementList) {
        int size = tableElementList.size();
        if (size == 0) {
            return;
        }
        this.print0(" (");
        ++this.indentCount;
        this.println();
        for (int i = 0; i < size; ++i) {
            SQLTableElement element = tableElementList.get(i);
            if (element instanceof SQLPrimaryKey) {
                SQLName name = ((SQLPrimaryKey)element).getName();
                if (name != null) {
                    this.printUcase("CONSTRAINT ");
                    name.accept(this);
                    this.print(' ');
                }
                this.printUcase("PRIMARY KEY ");
                this.acceptChildName(((SQLPrimaryKey)element).getColumns());
            } else if (element instanceof SQLUnique) {
                if ("UNIQUE".equalsIgnoreCase(((SQLUnique)element).getIndexDefinition().getType())) {
                    this.printUcase("UNIQUE ");
                }
                this.printUcase("KEY ");
                this.print(this.addIndexNameSuffixForH2(((SQLUnique)element).getName()));
                this.acceptChildName(((SQLUnique)element).getColumns());
            } else if (element instanceof MySqlTableIndex) {
                this.visit((MySqlTableIndex)element);
            } else {
                element.accept(this);
            }
            if (i != size - 1) {
                this.print(',');
            }
            if (this.isPrettyFormat() && element.hasAfterComment()) {
                this.print(' ');
                this.printlnComment(element.getAfterCommentsDirect());
            }
            if (i == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print(')');
    }

    private String addIndexNameSuffixForH2(SQLName name) {
        String simpleName = name.getSimpleName();
        if (simpleName.endsWith("`")) {
            return simpleName.replaceFirst("`$", System.nanoTime() + "`");
        }
        return simpleName + System.nanoTime();
    }

    public boolean visit(MySqlTableIndex x) {
        this.print0(this.ucase ? "INDEX" : "index");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        this.print('(');
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(')');
        return false;
    }

    private void acceptChildName(List<SQLSelectOrderByItem> children) {
        if (children == null) {
            return;
        }
        this.print('(');
        for (int i = 0; i < children.size(); ++i) {
            SQLSelectOrderByItem child = children.get(i);
            if (child == null) continue;
            if (child.getExpr() instanceof SQLMethodInvokeExpr) {
                this.print0(((SQLMethodInvokeExpr)child.getExpr()).getMethodName());
            } else {
                this.print0(child.getExpr().toString());
            }
            if (i == children.size() - 1) continue;
            this.print(',');
        }
        this.print(')');
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.printUcase("CREATE ");
        String type = x.getType();
        if ("UNIQUE".equalsIgnoreCase(type) || "SPATIAL".equalsIgnoreCase(type)) {
            this.printUcase(type + ' ');
        }
        this.printUcase("INDEX ");
        if (x.isIfNotExists()) {
            this.printUcase("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        this.printUcase(" ON ");
        x.getTable().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLHexExpr x) {
        this.print0("X'");
        this.print0(x.getHex());
        this.print0("'");
        return false;
    }

    @Override
    public boolean visit(SQLBinaryExpr x) {
        this.print0(x.getText());
        return false;
    }

    @Override
    protected void printChars(String text) {
        if ("0000-00-00 00:00:00".equals(text)) {
            LOG.warn("Replacing '0000-00-00 00:00:00' with valid H2 datetime (unsafe replacement)");
            text = "0001-01-01 00:00:00";
        }
        super.printChars(text);
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        this.printAlterTable(x);
        ++this.indentCount;
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem later;
            SQLAlterTableItem item = x.getItems().get(i);
            this.println();
            this.accept(item);
            if (i + 1 >= x.getItems().size() || !((later = x.getItems().get(i + 1)) instanceof MySqlAlterTableModifyColumn)) continue;
            this.print(";\n");
            this.printAlterTable(x);
        }
        --this.indentCount;
        return false;
    }

    private void printAlterTable(SQLAlterTableStatement x) {
        this.printUcase("ALTER TABLE ");
        if (x.isIfExists()) {
            this.printUcase("IF EXISTS ");
        }
        this.printTableSourceExpr(x.getName());
    }

    private void accept(SQLAlterTableItem item) {
        if (item instanceof MySqlAlterTableModifyColumn) {
            MySqlAlterTableModifyColumn x = (MySqlAlterTableModifyColumn)item;
            this.printUcase("ALTER COLUMN ");
            x.getNewColumnDefinition().accept(this);
        } else {
            item.accept(this);
        }
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        if (x.isWithNoCheck()) {
            this.print0(this.ucase ? "WITH NOCHECK " : "with nocheck ");
        }
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.getConstraint().getParent() instanceof SQLAlterTableAddConstraint && x.getConstraint() instanceof SQLForeignKeyImpl) {
            this.visit((SQLForeignKeyImpl)x.getConstraint());
        } else if (x.getConstraint().getParent() instanceof SQLAlterTableAddConstraint && x.getConstraint() instanceof SQLUnique) {
            this.visit((SQLUnique)x.getConstraint());
        } else {
            x.getConstraint().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUnique x) {
        SQLName name = x.getName();
        if (name != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            this.print(this.addIndexNameSuffixForH2(name));
            this.print(' ');
        }
        this.print0(this.ucase ? "UNIQUE (" : "unique (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        return false;
    }
}

