/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLScriptCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerObjectReferenceExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerRollbackStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerWaitForStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class SQLServerOutputVisitor
extends SQLASTOutputVisitor
implements SQLServerASTVisitor {
    public SQLServerOutputVisitor(Appendable appender) {
        super(appender, DbType.sqlserver);
    }

    public SQLServerOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.sqlserver;
    }

    @Override
    public boolean visit(SQLServerSelectQueryBlock x) {
        SQLOrderBy orderBy;
        SQLSelectGroupByClause groupBy;
        SQLExpr where;
        SQLTableSource from;
        this.print0(this.ucase ? "SELECT " : "select ");
        if (1 == x.getDistionOption()) {
            this.print0(this.ucase ? "ALL " : "all ");
        } else if (2 == x.getDistionOption()) {
            this.print0(this.ucase ? "DISTINCT " : "distinct ");
        } else if (3 == x.getDistionOption()) {
            this.print0(this.ucase ? "UNIQUE " : "unique ");
        }
        SQLServerTop top = x.getTop();
        if (top != null) {
            this.visit(top);
            this.print(' ');
        }
        this.printSelectList(x.getSelectList());
        SQLExprTableSource into = x.getInto();
        if (into != null) {
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            this.printTableSource(into);
        }
        if ((from = x.getFrom()) != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.printWhere(where);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            this.println();
            this.visit(groupBy);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            this.visit(orderBy);
        }
        this.printFetchFirst(x);
        return false;
    }

    @Override
    public boolean visit(SQLServerTop x) {
        boolean parameterized = this.parameterized;
        this.parameterized = false;
        this.print0(this.ucase ? "TOP " : "top ");
        boolean paren = false;
        if (x.getParent() instanceof SQLServerUpdateStatement || x.getParent() instanceof SQLServerInsertStatement) {
            paren = true;
            this.print('(');
        }
        x.getExpr().accept(this);
        if (paren) {
            this.print(')');
        }
        if (x.isPercent()) {
            this.print0(this.ucase ? " PERCENT" : " percent");
        }
        this.parameterized = parameterized;
        return false;
    }

    @Override
    public boolean visit(SQLServerObjectReferenceExpr x) {
        this.print0(x.toString());
        return false;
    }

    @Override
    public boolean visit(SQLServerInsertStatement x) {
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.getTop() != null) {
            x.getTop().setParent(x);
            x.getTop().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "INTO " : "into ");
        x.getTableSource().accept(this);
        this.printInsertColumns(x.getColumns());
        if (x.getOutput() != null) {
            this.println();
            x.getOutput().setParent(x);
            x.getOutput().accept(this);
        }
        if (!x.getValuesList().isEmpty()) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            int size = x.getValuesList().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(',');
                    this.println();
                }
                x.getValuesList().get(i).accept(this);
            }
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.isDefaultValues()) {
            this.print0(this.ucase ? " DEFAULT VALUES" : " default values");
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerUpdateStatement x) {
        SQLExpr where;
        SQLTableSource from;
        this.print0(this.ucase ? "UPDATE " : "update ");
        SQLServerTop top = x.getTop();
        if (top != null) {
            top.accept(this);
            this.print(' ');
        }
        this.printTableSource(x.getTableSource());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = x.getItems().get(i);
            this.visit(item);
        }
        SQLServerOutput output = x.getOutput();
        if (output != null) {
            this.println();
            this.visit(output);
        }
        if ((from = x.getFrom()) != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
            --this.indentCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        String alias = x.getAlias();
        if (alias != null) {
            this.print(' ');
            this.print0(alias);
        }
        if (this.isPrettyFormat() && x.hasAfterComment()) {
            this.print(' ');
            this.printlnComment(x.getAfterCommentsDirect());
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print0(this.ucase ? " WITH (" : " with (");
            this.printAndAccept(x.getHints(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        boolean parameterized = this.parameterized;
        this.parameterized = false;
        x.getName().accept(this);
        if (x.getDataType() != null) {
            this.print(' ');
            x.getDataType().accept(this);
        }
        if (x.getDefaultExpr() != null) {
            this.visitColumnDefault(x);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            this.print(' ');
            item.accept(this);
        }
        SQLColumnDefinition.Identity identity = x.getIdentity();
        if (identity != null) {
            this.print(' ');
            identity.accept(this);
        }
        if (x.getEnable() != null && x.getEnable().booleanValue()) {
            this.print0(this.ucase ? " ENABLE" : " enable");
        }
        this.parameterized = parameterized;
        return false;
    }

    @Override
    public boolean visit(SQLServerExecStatement x) {
        SQLName moduleName;
        this.print0(this.ucase ? "EXEC " : "exec ");
        SQLName returnStatus = x.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.accept(this);
            this.print0(" = ");
        }
        if ((moduleName = x.getModuleName()) != null) {
            moduleName.accept(this);
            this.print(' ');
        } else {
            this.print0(" (");
        }
        this.printAndAccept(x.getParameters(), ", ");
        if (moduleName == null) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerSetTransactionIsolationLevelStatement x) {
        this.print0(this.ucase ? "SET TRANSACTION ISOLATION LEVEL " : "set transaction isolation level ");
        this.print0(x.getLevel());
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        this.print0(this.ucase ? "SET " : "set ");
        SQLSetStatement.Option option = x.getOption();
        if (option != null) {
            this.print(option.name());
            this.print(' ');
        }
        List<SQLAssignItem> items = x.getItems();
        for (int i = 0; i < items.size(); ++i) {
            if (i != 0) {
                this.print0(", ");
            }
            SQLAssignItem item = x.getItems().get(i);
            item.getTarget().accept(this);
            SQLExpr value = item.getValue();
            if (value instanceof SQLIdentifierExpr && (((SQLIdentifierExpr)value).nameHashCode64() == FnvHash.Constants.ON || ((SQLIdentifierExpr)value).nameHashCode64() == FnvHash.Constants.OFF)) {
                this.print(' ');
            } else {
                this.print0(" = ");
            }
            value.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerOutput x) {
        this.print0(this.ucase ? "OUTPUT " : "output ");
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            ++this.indentCount;
            this.println();
            this.print0(this.ucase ? "INTO " : "into ");
            x.getInto().accept(this);
            if (x.getColumns().size() > 0) {
                ++this.indentCount;
                this.println();
                this.print('(');
                int size = x.getColumns().size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        if (i % 5 == 0) {
                            this.println();
                        }
                        this.print0(", ");
                    }
                    x.getColumns().get(i).accept(this);
                }
                this.print(')');
                --this.indentCount;
            }
        }
        --this.indentCount;
        return false;
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        this.print0(this.ucase ? "BEGIN" : "begin");
        ++this.indentCount;
        this.println();
        int size = x.getStatementList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement stmt = x.getStatementList().get(i);
            stmt.setParent(x);
            stmt.accept(this);
            this.print(';');
        }
        --this.indentCount;
        this.println();
        this.print0(this.ucase ? "END" : "end");
        return false;
    }

    @Override
    protected void printGrantOn(SQLGrantStatement x) {
        if (x.getResource() != null) {
            this.print0(this.ucase ? " ON " : " on ");
            if (x.getResourceType() != null) {
                this.print0(x.getResourceType().name());
                this.print0("::");
            }
            x.getResource().accept(this);
        }
    }

    @Override
    public boolean visit(SQLSelect x) {
        super.visit(x);
        if (x.isForBrowse()) {
            this.println();
            this.print0(this.ucase ? "FOR BROWSE" : "for browse");
        }
        if (x.getForXmlOptionsSize() > 0) {
            this.println();
            this.print0(this.ucase ? "FOR XML " : "for xml ");
            for (int i = 0; i < x.getForXmlOptions().size(); ++i) {
                if (i == 0) continue;
                this.print0(", ");
                this.print0(x.getForXmlOptions().get(i));
            }
        }
        if (x.getXmlPath() != null) {
            this.println();
            this.print0(this.ucase ? "FOR XML " : "for xml ");
            x.getXmlPath().accept(this);
        }
        if (x.getOffset() != null) {
            this.println();
            this.print0(this.ucase ? "OFFSET " : "offset ");
            x.getOffset().accept(this);
            this.print0(this.ucase ? " ROWS" : " rows");
            if (x.getRowCount() != null) {
                this.print0(this.ucase ? " FETCH NEXT " : " fetch next ");
                x.getRowCount().accept(this);
                this.print0(this.ucase ? " ROWS ONLY" : " rows only");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCommitStatement x) {
        this.print0(this.ucase ? "COMMIT" : "commit");
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        } else {
            this.print0(this.ucase ? " TRANSACTION" : " transaction");
            if (x.getTransactionName() != null) {
                this.print(' ');
                x.getTransactionName().accept(this);
            }
            if (x.getDelayedDurability() != null) {
                this.print0(this.ucase ? " WITH ( DELAYED_DURABILITY = " : " with ( delayed_durability = ");
                x.getDelayedDurability().accept(this);
                this.print0(" )");
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        } else {
            this.print0(this.ucase ? " TRANSACTION" : " transaction");
            if (x.getName() != null) {
                this.print(' ');
                x.getName().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerWaitForStatement x) {
        this.print0(this.ucase ? "WAITFOR" : "waitfor");
        if (x.getDelay() != null) {
            this.print0(this.ucase ? " DELAY " : " delay ");
            x.getDelay().accept(this);
        } else if (x.getTime() != null) {
            this.print0(this.ucase ? " TIME " : " time ");
            x.getTime().accept(this);
        }
        if (x.getStatement() != null) {
            this.print0(this.ucase ? " DELAY " : " delay ");
            x.getStatement().accept(this);
        }
        if (x.getTimeout() != null) {
            this.print0(this.ucase ? " ,TIMEOUT " : " ,timeout ");
            x.getTimeout().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLServerExecStatement.SQLServerParameter x) {
        x.getExpr().accept(this);
        if (x.getType()) {
            this.print0(this.ucase ? " OUT" : " out");
        }
        return false;
    }

    @Override
    public boolean visit(SQLStartTransactionStatement x) {
        this.print0(this.ucase ? "BEGIN TRANSACTION" : "begin transaction");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLScriptCommitStatement x) {
        this.print0(this.ucase ? "GO" : "go");
        return false;
    }

    @Override
    public boolean visit(SQLCreateUserStatement x) {
        this.print0(this.ucase ? "CREATE USER " : "create user ");
        x.getUser().accept(this);
        this.print0(this.ucase ? " WITH PASSWORD = " : " with password = ");
        SQLExpr passoword = x.getPassword();
        if (passoword instanceof SQLIdentifierExpr) {
            this.print('\'');
            passoword.accept(this);
            this.print('\'');
        } else {
            passoword.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSequenceExpr x) {
        SQLSequenceExpr.Function function = x.getFunction();
        switch (function) {
            case NextVal: {
                this.print0(this.ucase ? "NEXT VALUE FOR " : "next value for ");
                break;
            }
            default: {
                throw new ParserException("not support function : " + (Object)((Object)function));
            }
        }
        this.printExpr(x.getSequence());
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        boolean odps = this.isOdps();
        this.print0(this.ucase ? "ADD " : "add ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }
}

