/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.protocal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.serialize.JsonSerializer;

public class TransporterHeader
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final AtomicLong REQUEST_ID = new AtomicLong(1L);
    private String methodIdentifier;
    private long opaque;

    public TransporterHeader() {
    }

    public TransporterHeader(String methodIdentifier) {
        this(REQUEST_ID.getAndIncrement(), methodIdentifier);
    }

    public TransporterHeader(long opaque, String methodIdentifier) {
        this.opaque = opaque;
        this.methodIdentifier = methodIdentifier;
    }

    public static TransporterHeader of(String methodIdentifier) {
        return new TransporterHeader(methodIdentifier);
    }

    public static TransporterHeader of(long opaque, String methodIdentifier) {
        return new TransporterHeader(opaque, methodIdentifier);
    }

    public byte[] toBytes() {
        return JsonSerializer.serialize(this);
    }

    @Generated
    public String getMethodIdentifier() {
        return this.methodIdentifier;
    }

    @Generated
    public long getOpaque() {
        return this.opaque;
    }

    @Generated
    public void setMethodIdentifier(String methodIdentifier) {
        this.methodIdentifier = methodIdentifier;
    }

    @Generated
    public void setOpaque(long opaque) {
        this.opaque = opaque;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransporterHeader)) {
            return false;
        }
        TransporterHeader other = (TransporterHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOpaque() != other.getOpaque()) {
            return false;
        }
        String this$methodIdentifier = this.getMethodIdentifier();
        String other$methodIdentifier = other.getMethodIdentifier();
        return !(this$methodIdentifier == null ? other$methodIdentifier != null : !this$methodIdentifier.equals(other$methodIdentifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransporterHeader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $opaque = this.getOpaque();
        result = result * 59 + (int)($opaque >>> 32 ^ $opaque);
        String $methodIdentifier = this.getMethodIdentifier();
        result = result * 59 + ($methodIdentifier == null ? 43 : $methodIdentifier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransporterHeader(methodIdentifier=" + this.getMethodIdentifier() + ", opaque=" + this.getOpaque() + ")";
    }
}

