/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;

public class TaskNode {
    private String id;
    private long code;
    private int version;
    private String name;
    private String desc;
    private String type;
    private String runFlag;
    private String loc;
    private int maxRetryTimes;
    private int retryInterval;
    private int taskGroupId;
    private int taskGroupPriority;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String params;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String preTasks;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String extras;
    private List<Long> depList;
    private Priority taskInstancePriority;
    private String workerGroup;
    private Long environmentCode;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String timeout;
    private int delayTime;
    private Integer cpuQuota;
    private Integer memoryMax;
    private TaskExecuteType taskExecuteType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getPreTasks() {
        return this.preTasks;
    }

    public void setPreTasks(String preTasks) {
        this.preTasks = preTasks;
        this.depList = JSONUtils.toList((String)preTasks, Long.class);
    }

    public String getExtras() {
        return this.extras;
    }

    public void setExtras(String extras) {
        this.extras = extras;
    }

    public List<Long> getDepList() {
        return this.depList;
    }

    public void setDepList(List<Long> depList) {
        if (depList != null) {
            this.depList = depList;
            this.preTasks = JSONUtils.toJsonString(depList);
        }
    }

    public String getLoc() {
        return this.loc;
    }

    public void setLoc(String loc) {
        this.loc = loc;
    }

    public String getRunFlag() {
        return this.runFlag;
    }

    public void setRunFlag(String runFlag) {
        this.runFlag = runFlag;
    }

    public boolean isForbidden() {
        if (this.taskExecuteType == TaskExecuteType.STREAM) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)this.runFlag) && this.runFlag.equals("FORBIDDEN");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskNode taskNode = (TaskNode)o;
        return Objects.equals(this.name, taskNode.name) && Objects.equals(this.desc, taskNode.desc) && Objects.equals(this.type, taskNode.type) && Objects.equals(this.params, taskNode.params) && Objects.equals(this.preTasks, taskNode.preTasks) && Objects.equals(this.extras, taskNode.extras) && Objects.equals(this.runFlag, taskNode.runFlag) && Objects.equals(this.workerGroup, taskNode.workerGroup) && Objects.equals(this.environmentCode, taskNode.environmentCode) && CollectionUtils.isEqualCollection(this.depList, taskNode.depList) && Objects.equals(this.taskExecuteType, taskNode.taskExecuteType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.desc, this.type, this.params, this.preTasks, this.extras, this.depList, this.runFlag);
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        return "TaskNode{id='" + this.id + '\'' + ", code=" + this.code + ", version=" + this.version + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", type='" + this.type + '\'' + ", runFlag='" + this.runFlag + '\'' + ", loc='" + this.loc + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", params='" + this.params + '\'' + ", preTasks='" + this.preTasks + '\'' + ", extras='" + this.extras + '\'' + ", depList=" + this.depList + ", taskInstancePriority=" + this.taskInstancePriority + ", workerGroup='" + this.workerGroup + '\'' + ", environmentCode=" + this.environmentCode + ", timeout='" + this.timeout + '\'' + ", delayTime=" + this.delayTime + '\'' + ", taskExecuteType=" + this.taskExecuteType + '}';
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    public void setTaskGroupId(int taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    public int getTaskGroupPriority() {
        return this.taskGroupPriority;
    }

    public void setTaskGroupPriority(int taskGroupPriority) {
        this.taskGroupPriority = taskGroupPriority;
    }

    public Integer getCpuQuota() {
        return this.cpuQuota == null ? -1 : this.cpuQuota;
    }

    public void setCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public Integer getMemoryMax() {
        return this.memoryMax == null ? -1 : this.memoryMax;
    }

    public void setMemoryMax(Integer memoryMax) {
        this.memoryMax = memoryMax;
    }

    public TaskExecuteType getTaskExecuteType() {
        return this.taskExecuteType;
    }

    public void setTaskExecuteType(TaskExecuteType taskExecuteType) {
        this.taskExecuteType = taskExecuteType;
    }
}

