/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.config;

import lombok.Generated;
import org.apache.dolphinscheduler.meter.metrics.BaseServerLoadProtection;
import org.apache.dolphinscheduler.meter.metrics.BaseServerLoadProtectionConfig;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.config.MasterServerLoadProtectionConfig;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterServerLoadProtection
extends BaseServerLoadProtection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterServerLoadProtection.class);
    private final IWorkflowRepository workflowRepository;
    private final MasterServerLoadProtectionConfig masterServerLoadProtectionConfig;

    public MasterServerLoadProtection(IWorkflowRepository workflowRepository, MasterConfig masterConfig) {
        super((BaseServerLoadProtectionConfig)masterConfig.getServerLoadProtection());
        this.masterServerLoadProtectionConfig = masterConfig.getServerLoadProtection();
        this.workflowRepository = workflowRepository;
    }

    public boolean isOverload(SystemMetrics systemMetrics) {
        if (!this.masterServerLoadProtectionConfig.isEnabled()) {
            return false;
        }
        if (super.isOverload(systemMetrics)) {
            return true;
        }
        int currentWorkflowInstanceCount = this.workflowRepository.getAll().size();
        if (currentWorkflowInstanceCount >= this.masterServerLoadProtectionConfig.getMaxConcurrentWorkflowInstances()) {
            log.info("OverLoad: the workflow instance count: {} exceeds the maxConcurrentWorkflowInstances {}", (Object)currentWorkflowInstanceCount, (Object)this.masterServerLoadProtectionConfig.getMaxConcurrentWorkflowInstances());
            return true;
        }
        return false;
    }
}

