/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.statemachine;

import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFailedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPausedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStartLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStopLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStoppedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowSucceedLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.statemachine.AbstractWorkflowStateAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowRunningStateAction
extends AbstractWorkflowStateAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowRunningStateAction.class);

    @Override
    public void onStartEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStartLifecycleEvent workflowStartEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph();
        List<ITaskExecutionRunnable> startNodes = workflowExecutionGraph.getStartNodes();
        if (startNodes.isEmpty()) {
            log.info("Workflow start node is empty, try to emit workflow finished event");
            this.emitWorkflowFinishedEventIfApplicable(workflowExecutionRunnable);
            return;
        }
        this.triggerTasks(workflowExecutionRunnable, startNodes);
    }

    @Override
    public void onTopologyLogicalTransitionEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowTopologyLogicalTransitionWithTaskFinishLifecycleEvent workflowTopologyLogicalTransitionWithTaskFinishEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        ITaskExecutionRunnable taskExecutionRunnable = workflowTopologyLogicalTransitionWithTaskFinishEvent.getTaskExecutionRunnable();
        workflowExecutionRunnable.getWorkflowExecutionGraph().markTaskExecutionRunnableInActive(taskExecutionRunnable);
        super.tryToTriggerSuccessorsAfterTaskFinish(workflowExecutionRunnable, taskExecutionRunnable);
    }

    @Override
    public void onPauseEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPauseLifecycleEvent workflowPauseEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.transformWorkflowInstanceState(workflowExecutionRunnable, WorkflowExecutionStatus.READY_PAUSE);
        super.pauseActiveTask(workflowExecutionRunnable);
    }

    @Override
    public void onPausedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowPausedLifecycleEvent workflowPausedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowPausedEvent);
    }

    @Override
    public void onStopEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStopLifecycleEvent workflowStopEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        super.transformWorkflowInstanceState(workflowExecutionRunnable, WorkflowExecutionStatus.READY_STOP);
        super.killActiveTask(workflowExecutionRunnable);
    }

    @Override
    public void onStoppedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowStoppedLifecycleEvent workflowStoppedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        if (!workflowExecutionRunnable.getWorkflowExecutionGraph().isExistKilledTaskExecutionRunnableChain()) {
            throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + " does not exist tasks chain which is killed");
        }
        super.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.STOP);
    }

    @Override
    public void onSucceedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowSucceedLifecycleEvent workflowSucceedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (!workflowExecutionGraph.isAllTaskExecutionRunnableChainSuccess()) {
            throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + "exist tasks chain which is not success");
        }
        this.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.SUCCESS);
    }

    @Override
    public void onFailedEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFailedLifecycleEvent workflowFailedEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        if (!workflowExecutionGraph.isExistFailureTaskExecutionRunnableChain()) {
            throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + " does not exist tasks chain which is failed");
        }
        this.workflowFinish(workflowExecutionRunnable, WorkflowExecutionStatus.FAILURE);
    }

    @Override
    public void onFinalizeEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, WorkflowFinalizeLifecycleEvent workflowFinalizeEvent) {
        this.throwExceptionIfStateIsNotMatch(workflowExecutionRunnable);
        this.logWarningIfCannotDoAction(workflowExecutionRunnable, workflowFinalizeEvent);
    }

    @Override
    public WorkflowExecutionStatus matchState() {
        return WorkflowExecutionStatus.RUNNING_EXECUTION;
    }

    @Override
    protected void emitWorkflowFinishedEventIfApplicable(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        if (!this.isWorkflowFinishable(workflowExecutionRunnable)) {
            log.debug("There exist task which is not finish, don't need to emit workflow finished event");
            return;
        }
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecutionRunnable.getWorkflowExecutionGraph();
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        if (workflowExecutionGraph.isExistFailureTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowFailedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isExistKilledTaskExecutionRunnableChain()) {
            workflowEventBus.publish(WorkflowStoppedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        if (workflowExecutionGraph.isAllTaskExecutionRunnableChainSuccess()) {
            workflowEventBus.publish(WorkflowSucceedLifecycleEvent.of(workflowExecutionRunnable));
            return;
        }
        throw new IllegalStateException("The workflow: " + workflowExecutionRunnable.getName() + " state is " + workflowExecutionRunnable.getState() + " can only finish with task success/failed/killed but exist task which state is not success\u3001failure\u3001killed");
    }
}

