/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Test;
import org.apache.flex.forks.velocity.Template;
import org.apache.flex.forks.velocity.VelocityContext;
import org.apache.flex.forks.velocity.app.Velocity;
import org.apache.flex.forks.velocity.runtime.RuntimeSingleton;
import org.apache.flex.forks.velocity.test.BaseTestCase;

public class MultipleFileResourcePathTest
extends BaseTestCase {
    private static final String TMPL_FILE_EXT = "vm";
    private static final String CMP_FILE_EXT = "cmp";
    private static final String RESULT_FILE_EXT = "res";
    private static final String FILE_RESOURCE_LOADER_PATH1 = "../test/multi/path1";
    private static final String FILE_RESOURCE_LOADER_PATH2 = "../test/multi/path2";
    private static final String RESULTS_DIR = "../test/multi/results";
    private static final String COMPARE_DIR = "../test/multi/compare";

    MultipleFileResourcePathTest() {
        super("MultipleFileResourcePathTest");
        try {
            MultipleFileResourcePathTest.assureResultsDirectoryExists(RESULTS_DIR);
            Velocity.addProperty("file.resource.loader.path", FILE_RESOURCE_LOADER_PATH1);
            Velocity.addProperty("file.resource.loader.path", FILE_RESOURCE_LOADER_PATH2);
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup MultipleFileResourcePathTest!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Test suite() {
        return new MultipleFileResourcePathTest();
    }

    public void runTest() {
        try {
            Template template1 = RuntimeSingleton.getTemplate(MultipleFileResourcePathTest.getFileName(null, "path1", TMPL_FILE_EXT));
            Template template2 = RuntimeSingleton.getTemplate(MultipleFileResourcePathTest.getFileName(null, "path2", TMPL_FILE_EXT));
            FileOutputStream fos1 = new FileOutputStream(MultipleFileResourcePathTest.getFileName(RESULTS_DIR, "path1", RESULT_FILE_EXT));
            FileOutputStream fos2 = new FileOutputStream(MultipleFileResourcePathTest.getFileName(RESULTS_DIR, "path2", RESULT_FILE_EXT));
            BufferedWriter writer1 = new BufferedWriter(new OutputStreamWriter(fos1));
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(fos2));
            VelocityContext context = new VelocityContext();
            template1.merge(context, writer1);
            ((Writer)writer1).flush();
            ((Writer)writer1).close();
            template2.merge(context, writer2);
            ((Writer)writer2).flush();
            ((Writer)writer2).close();
            if (!this.isMatch(RESULTS_DIR, COMPARE_DIR, "path1", RESULT_FILE_EXT, CMP_FILE_EXT) || !this.isMatch(RESULTS_DIR, COMPARE_DIR, "path2", RESULT_FILE_EXT, CMP_FILE_EXT)) {
                MultipleFileResourcePathTest.fail((String)"Output incorrect.");
            }
        }
        catch (Exception e) {
            MultipleFileResourcePathTest.fail((String)e.getMessage());
        }
    }
}

