/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public class NumericConversions {
    public static final long TwoPow31 = 0x80000000L;
    public static final long TwoPow32 = 0x100000000L;

    public static long toUint32(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || 0.0 == d) {
            return 0L;
        }
        double result3 = Math.floor(Math.abs(d));
        return (long)result3 % 0x100000000L;
    }

    public static int toInt32(double d) {
        long result4 = (long)Math.signum(d) * NumericConversions.toUint32(d);
        if (result4 >= 0x80000000L) {
            return (int)(result4 - 0x100000000L);
        }
        return (int)result4;
    }
}

