/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.computer.core.sort.flusher;

import java.util.NoSuchElementException;

import org.apache.hugegraph.iterator.CIter;

public interface PeekableIterator<T> extends CIter<T> {

    @SuppressWarnings("unchecked")
    static <V> PeekableIterator<V> emptyIterator() {
        return (PeekableIterator<V>) EmptyIterator.EMPTY_ITERATOR;
    }

    T peek();

    class EmptyIterator<E> implements PeekableIterator<E> {

        static final EmptyIterator<Object> EMPTY_ITERATOR =
                                           new EmptyIterator<>();

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public Object metadata(String s, Object... objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E peek() {
            throw new NoSuchElementException();
        }

        @Override
        public void close() throws Exception {
            // pass
        }
    }
}
