/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropSchemaBehavior;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlDropSchema
extends SqlDrop {
    private final SqlIdentifier name;
    private final IgniteSqlDropSchemaBehavior behavior;

    public IgniteSqlDropSchema(SqlParserPos pos, boolean ifExists, SqlIdentifier name, IgniteSqlDropSchemaBehavior behavior) {
        super((SqlOperator)new Operator(ifExists, behavior), pos, ifExists);
        this.name = Objects.requireNonNull(name, "schema name");
        this.behavior = behavior;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        switch (this.behavior) {
            case RESTRICT: {
                writer.keyword("RESTRICT");
                break;
            }
            case CASCADE: {
                writer.keyword("CASCADE");
                break;
            }
            case IMPLICIT_RESTRICT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected drop behavior: " + String.valueOf((Object)this.behavior));
            }
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public boolean ifExists() {
        Operator operator = (Operator)this.getOperator();
        return operator.existFlag();
    }

    public IgniteSqlDropSchemaBehavior behavior() {
        return this.behavior;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        private final IgniteSqlDropSchemaBehavior dropBehavior;

        protected Operator(boolean existFlag, IgniteSqlDropSchemaBehavior dropBehavior) {
            super("DROP SCHEMA", SqlKind.OTHER_DDL, existFlag);
            this.dropBehavior = dropBehavior;
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlDropSchema(pos, this.existFlag(), (SqlIdentifier)operands[0], this.dropBehavior);
        }
    }
}

