/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.concurrent.Executor;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.core.NotLeaderException;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.RpcContext;
import org.apache.ignite3.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite3.raft.jraft.rpc.RpcRequestClosure;

public abstract class RpcRequestProcessor<T extends Message>
implements RpcProcessor<T> {
    protected static final IgniteLogger LOG = Loggers.forClass(RpcRequestProcessor.class);
    private final Executor executor;
    private final RaftMessagesFactory msgFactory;

    public abstract Message processRequest(T var1, RpcRequestClosure var2);

    public RpcRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        this.executor = executor;
        this.msgFactory = msgFactory;
    }

    @Override
    public void handleRequest(RpcContext rpcCtx, T request) {
        try {
            Message msg = this.processRequest(request, new RpcRequestClosure(rpcCtx, this.msgFactory));
            if (msg != null) {
                rpcCtx.sendResponse(msg);
            }
        }
        catch (NotLeaderException t) {
            LOG.debug("handleRequest {} failed", t, request);
            rpcCtx.sendResponse(RaftRpcFactory.DEFAULT.newResponse(t.leaderId(), this.msgFactory, RaftError.EPERM, t.getMessage(), new Object[0]));
        }
        catch (Throwable t) {
            LOG.error("handleRequest {} failed", t, request);
            rpcCtx.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, RaftError.UNKNOWN.getNumber(), "handleRequest internal error", new Object[0]));
        }
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    public RaftMessagesFactory msgFactory() {
        return this.msgFactory;
    }
}

