/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.FieldMatcher;
import org.nutz.dao.Nesting;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Pojos;
import org.nutz.lang.Lang;

public class SimpleNesting
implements Nesting {
    private static final String DISTINCT = "distinct";
    protected JdbcExpert expert;
    protected EntityHolder holder;
    private Pojo pojo;

    public SimpleNesting(Dao dao) {
        this.expert = dao.getJdbcExpert();
        this.holder = dao.getEntityHolder();
    }

    @Override
    public Nesting select(String names, Class<?> clazz, Condition cnd) {
        Pager pager;
        this.make(clazz);
        this.distinct(this.pojo, names);
        this.pojo.append(Pojos.Items.queryEntityFields());
        this.pojo.append(Pojos.Items.wrap("FROM"));
        this.pojo.append(Pojos.Items.entityViewName());
        this.pojo.append(Pojos.Items.cnd(cnd));
        if (cnd instanceof Cnd && (pager = ((Cnd)cnd).getPager()) != null) {
            this.pojo.setPager(pager);
        }
        this.expert.formatQuery(this.pojo);
        return this;
    }

    private Pojo make(Class<?> clazz) {
        Entity<?> en = this.holder.getEntity(clazz);
        this.pojo = Pojos.pojo(this.expert, en, SqlType.SELECT);
        this.pojo.setEntity(en);
        return this.pojo;
    }

    private Pojo distinct(Pojo pojo, String names) {
        if (!Lang.isEmpty(names) && names.length() != 0) {
            List<String> nameList = Arrays.asList(names.trim().split(","));
            if (names.toLowerCase().contains(DISTINCT)) {
                pojo.append(Pojos.Items.wrap(DISTINCT));
                for (int i = 0; i < nameList.size(); ++i) {
                    if (!nameList.get(i).toLowerCase().contains(DISTINCT)) continue;
                    Collections.swap(nameList, 0, i);
                    nameList.set(0, nameList.get(0).toLowerCase().replace(DISTINCT, "").toLowerCase());
                    break;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (String name : nameList) {
                sb.append(name.trim());
                sb.append("|");
            }
            sb.setLength(sb.length() - 1);
            pojo.getContext().setFieldMatcher(FieldMatcher.make(sb.toString(), null, true));
        }
        return pojo;
    }

    public String toString() {
        return this.pojo.toString();
    }
}

