/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;

class ReadOnceInputStream
extends FilterInputStream
implements Serializable {
    private static final long serialVersionUID = -2601685798106193691L;
    private File f;
    public boolean readed;

    protected ReadOnceInputStream(File f) throws FileNotFoundException {
        super(new FileInputStream(f));
        this.f = f;
    }

    @Override
    public int read() throws IOException {
        this.readed = true;
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readed = true;
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readed = true;
        return super.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.f.delete();
    }

    protected void finalize() throws Throwable {
        this.f.delete();
        super.finalize();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Streams.writeAndClose((OutputStream)out, new FileInputStream(this.f));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.f = Jdbcs.getFilePool().createFile(".dat");
        Files.write(this.f, (Object)in);
    }
}

