/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.mvc.adaptor.ParamInjector;

public class NameInjector
implements ParamInjector {
    protected String name;
    protected DateFormat dfmt;
    protected Class<?> klass;
    protected Type type;
    protected Type[] paramTypes;
    protected String defaultValue;

    public NameInjector(String name, String datefmt, Type type, Type[] paramTypes, String defaultValue) {
        this.klass = Mirror.me(type).getType();
        if (null == name) {
            throw Lang.makeThrow("Can not accept null as name, type '%s'", this.klass.getName());
        }
        this.name = name;
        this.dfmt = Strings.isBlank(datefmt) || !Mirror.me(this.klass).isDateTimeLike() ? null : new SimpleDateFormat(datefmt);
        this.type = type;
        this.paramTypes = paramTypes;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object get(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, Object refer) {
        if (null != refer) {
            if (refer instanceof Map) {
                Object value = ((Map)refer).get(this.name);
                if (value == null) {
                    return this.fromReqParam(req);
                }
                if (value instanceof Collection && null != this.paramTypes && this.paramTypes.length > 0) {
                    try {
                        Collection col = (Collection)value;
                        Collection nw = (Collection)col.getClass().newInstance();
                        Class<?> eleType = Lang.getTypeClass(this.paramTypes[0]);
                        for (Object ele : col) {
                            Object obj = Castors.me().castTo(ele, eleType);
                            nw.add(obj);
                        }
                        value = nw;
                    }
                    catch (Exception e) {
                        throw Lang.wrapThrow(e);
                    }
                }
                return Castors.me().castTo(value, this.klass);
            }
            return Castors.me().castTo(refer, this.klass);
        }
        return this.fromReqParam(req);
    }

    public Object fromReqParam(HttpServletRequest req) {
        String[] params = req.getParameterValues(this.name);
        if (null != this.dfmt && params != null && params.length > 0) {
            Date o = Times.parseq(this.dfmt, params[0]);
            return Castors.me().castTo(o, this.klass);
        }
        if ((params == null || params.length == 0) && this.defaultValue != null) {
            params = new String[]{this.defaultValue};
        }
        return Castors.me().castTo(params, this.klass);
    }
}

