/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.chainconfig;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.impl.chainconfig.ActionChainMakerConfiguration;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class JsonActionChainMakerConfiguretion
implements ActionChainMakerConfiguration {
    private static final Log log = Logs.get();
    protected Map<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();

    public JsonActionChainMakerConfiguretion(String ... jsonPaths) {
        List<NutResource> list = Scans.me().loadResource("^(.+[.])(js|json)$", jsonPaths);
        try {
            this.map.putAll(Json.fromJson(Map.class, (Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("org/nutz/mvc/impl/chainconfig/default-chains.js"))));
            if (!list.isEmpty()) {
                for (NutResource nr : list) {
                    this.map.putAll(Json.fromJson(Map.class, nr.getReader()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("ActionChain Config:\n" + Json.toJson(this.map));
                }
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    @Override
    public List<String> getProcessors(String key) {
        Map<String, Object> config = this.map.get(key);
        if (config != null && config.containsKey("ps")) {
            return (List)config.get("ps");
        }
        return (List)this.map.get("default").get("ps");
    }

    @Override
    public String getErrorProcessor(String key) {
        Map<String, Object> config = this.map.get(key);
        if (config != null && config.containsKey("error")) {
            return (String)config.get("error");
        }
        return (String)this.map.get("default").get("error");
    }
}

