/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.List;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.client.migration.MigrationAddressComparator;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;

public class DefaultMigrationAddressComparator
implements MigrationAddressComparator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMigrationAddressComparator.class);
    private static final String MIGRATION_THRESHOLD = "dubbo.application.migration.threshold";
    private static final String DEFAULT_THRESHOLD_STRING = "0.8";
    private static final float DEFAULT_THREAD = 0.8f;

    @Override
    public <T> boolean shouldMigrate(ClusterInvoker<T> serviceDiscoveryInvoker, ClusterInvoker<T> invoker) {
        float threshold;
        if (!serviceDiscoveryInvoker.isAvailable()) {
            logger.info("No instance address available, will not migrate.");
            return false;
        }
        if (!invoker.isAvailable()) {
            logger.info("No interface address available, will migrate.");
            return true;
        }
        List<Invoker<T>> invokers1 = serviceDiscoveryInvoker.getDirectory().getAllInvokers();
        List<Invoker<T>> invokers2 = invoker.getDirectory().getAllInvokers();
        int newAddressSize = CollectionUtils.isNotEmpty(invokers1) ? invokers1.size() : 0;
        int oldAddressSize = CollectionUtils.isNotEmpty(invokers2) ? invokers2.size() : 0;
        String rawThreshold = ConfigurationUtils.getDynamicProperty(MIGRATION_THRESHOLD, DEFAULT_THRESHOLD_STRING);
        try {
            threshold = Float.parseFloat(rawThreshold);
        }
        catch (Exception e) {
            logger.error("Invalid migration threshold " + rawThreshold);
            threshold = 0.8f;
        }
        logger.info("Instance address size " + newAddressSize + ", interface address size " + oldAddressSize + ", threshold " + threshold);
        if (newAddressSize != 0 && oldAddressSize == 0) {
            return true;
        }
        if (newAddressSize == 0 && oldAddressSize == 0) {
            return false;
        }
        return (float)newAddressSize / (float)oldAddressSize >= threshold;
    }
}

