/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.convert.converter.config;

import com.alibaba.nacos.api.config.convert.NacosConfigConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;

public class DefaultNacosConfigConverter<T>
implements NacosConfigConverter<T> {
    private final Class<T> targetType;
    private final ConversionService conversionService;
    private final String type;

    public DefaultNacosConfigConverter(Class<T> targetType) {
        this(targetType, (ConversionService)new DefaultFormattingConversionService(), "properties");
    }

    public DefaultNacosConfigConverter(Class<T> targetType, ConversionService conversionService, String type) {
        this.targetType = targetType;
        this.conversionService = conversionService;
        this.type = type;
    }

    public T convert(String source) {
        if (this.conversionService.canConvert(source.getClass(), this.targetType)) {
            return (T)this.conversionService.convert((Object)source, this.targetType);
        }
        return null;
    }

    public boolean canConvert(Class<T> targetType) {
        return this.conversionService.canConvert(String.class, targetType);
    }
}

