/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.infra.rpc.errors;

import java.util.Set;
import java.util.TreeSet;

public class ErrorScope {
    private int scopeId;
    private static Set<Integer> scopes = new TreeSet<Integer>();

    private ErrorScope(int scopeId) {
        this.scopeId = scopeId;
    }

    public static ErrorScope createOnce(int scopeId) {
        if (scopeId < 0 || scopeId >= 1000) {
            throw new IllegalArgumentException("Bad scope range:" + scopeId);
        }
        if (scopes.contains(scopeId)) {
            throw new IllegalArgumentException("Duplicate scope id:" + scopeId);
        }
        ErrorScope scope = new ErrorScope(scopeId);
        scopes.add(scopeId);
        return scope;
    }

    public int getScopeId() {
        return this.scopeId;
    }
}

