/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.memory;

import cn.hutool.core.io.FileUtil;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xiaomi.mone.file.FileUtils;
import com.xiaomi.mone.file.ReadResult;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.memory.AgentMemoryService;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.agent.common.AbstractElementAdapter;
import org.apache.ozhera.log.agent.common.ExecutorUtil;
import org.apache.ozhera.log.agent.exception.AgentException;
import org.apache.ozhera.log.agent.input.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentMemoryServiceImpl
implements AgentMemoryService {
    private static final Logger log = LoggerFactory.getLogger(AgentMemoryServiceImpl.class);
    private static ConcurrentHashMap<Long, File> memoryFileList = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, ChannelMemory> channelMemoryMap = new ConcurrentHashMap();
    private String basePath;
    private static Gson gson;

    public AgentMemoryServiceImpl(String basePath) {
        this.basePath = basePath;
        AgentMemoryServiceImpl.initFolder(this.basePath + "/milog/memory/");
        this.initChannelMemory();
        this.initFlushTask(this);
    }

    private static void initFolder(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("initFolder:{} exception:{}", (Object)dir, (Object)e);
                throw new AgentException(dir + " create exception", e);
            }
        } else {
            log.info("dir:{} is exists,no need to create", (Object)dir);
        }
    }

    private void initChannelMemory() {
        List<ChannelMemory> channelMemoryList = this.restoreFromDisk();
        if (CollectionUtils.isEmpty(channelMemoryList)) {
            return;
        }
        log.info("memory data:{}", (Object)gson.toJson(channelMemoryList));
        channelMemoryList.forEach(c -> {
            if (c != null && "2.0".equals(c.getVersion())) {
                this.channelMemoryMap.put(c.getChannelId(), (ChannelMemory)c);
            }
        });
    }

    private void initFlushTask(final AgentMemoryService agentMemoryService) {
        ExecutorUtil.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                agentMemoryService.flush2disk(agentMemoryService.getMemory());
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void refreshMemory(ChannelMemory channelMemory) {
        this.channelMemoryMap.put(channelMemory.getChannelId(), channelMemory);
        this.flush2disk(Lists.newArrayList((Object[])new ChannelMemory[]{channelMemory}));
    }

    @Override
    public List<ChannelMemory> getMemory() {
        return new ArrayList<ChannelMemory>(this.channelMemoryMap.values());
    }

    @Override
    public ChannelMemory getMemory(Long channelId) {
        return this.channelMemoryMap.get(channelId);
    }

    @Override
    public List<ChannelMemory> restoreFromDisk() {
        ArrayList<ChannelMemory> channelMemoryList = new ArrayList<ChannelMemory>();
        File file = new File(this.basePath + "/milog/memory/");
        File[] fs = file.listFiles();
        if (null == fs || fs.length == 0) {
            return Lists.newArrayList();
        }
        for (File f : fs) {
            if (f.isDirectory()) continue;
            try {
                ReadResult readResult;
                List list;
                if (!f.getName().startsWith("channel_") || !CollectionUtils.isNotEmpty((Collection)(list = (readResult = FileUtils.readFile((String)f.getAbsolutePath(), (long)0L, (int)0)).getLines()))) continue;
                String channel = (String)list.get(0);
                ChannelMemory channelMemory = (ChannelMemory)gson.fromJson(channel, ChannelMemory.class);
                if (channelMemory != null && "2.0".equals(channelMemory.getVersion())) {
                    channelMemoryList.add(channelMemory);
                }
                log.warn("restoreFromDisk channel:{},channelMemory:{}", (Object)channel, (Object)channelMemory);
            }
            catch (Exception e) {
                log.error("restoreFromDisk error,file:{}", (Object)f.getName(), (Object)e);
            }
        }
        return channelMemoryList;
    }

    @Override
    public void flush2disk(List<ChannelMemory> channelMemoryList) {
        for (ChannelMemory channelMemory : channelMemoryList) {
            FileWriter writer = null;
            try {
                Long channelId = channelMemory.getChannelId();
                File memoryFile = memoryFileList.get(channelId);
                if (null == memoryFile) {
                    memoryFile = new File(this.basePath + "/milog/memory/channel_" + channelId);
                    if (!memoryFile.exists()) {
                        try {
                            memoryFile.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    memoryFileList.put(channelId, memoryFile);
                }
                writer = new FileWriter(memoryFile, false);
                writer.append(gson.toJson((Object)channelMemory));
                writer.flush();
            }
            catch (Throwable e) {
                log.error("flush2disk error, channelId:{}", (Object)channelMemory.getChannelId(), (Object)e);
            }
        }
    }

    @Override
    public void cleanChannelMemoryContent(Long channelId, List<String> filePaths) {
        ChannelMemory channelMemory = this.channelMemoryMap.get(channelId);
        if (null != channelMemory) {
            Map<String, ChannelMemory.FileProgress> fileProgressMap = channelMemory.getFileProgressMap();
            List<String> expireFilePaths = fileProgressMap.keySet().stream().filter(filePath -> !filePaths.contains(filePath)).collect(Collectors.toList());
            expireFilePaths.forEach(expireFilePath -> fileProgressMap.remove(expireFilePath));
            this.flush2disk(Lists.newArrayList((Object[])new ChannelMemory[]{channelMemory}));
        }
    }

    @Override
    public void cleanMemoryHistoryFile(List<Long> channelIds) {
        try {
            log.info("all channelIds:{}", (Object)gson.toJson(channelIds));
            List channelIdList = channelIds.stream().map(String::valueOf).collect(Collectors.toList());
            List files = FileUtil.loopFiles((String)(this.basePath + "/milog/memory/"));
            Map fileMap = files.stream().collect(Collectors.toMap(File::getName, Function.identity(), (file, file2) -> file2));
            for (String fileName : fileMap.keySet()) {
                if (channelIdList.contains(StringUtils.substringAfter((String)fileName, (String)"channel_"))) continue;
                ((File)fileMap.get(fileName)).delete();
            }
        }
        catch (Exception e) {
            log.error("cleanMemoryHistoryFile error,channelIds:{}", (Object)gson.toJson(channelIds), (Object)e);
        }
    }

    private void fixedData() {
        this.channelMemoryMap.entrySet().stream().forEach(memoryEntry -> {
            ChannelMemory channelMemory = (ChannelMemory)memoryEntry.getValue();
            channelMemory.getFileProgressMap().entrySet().forEach(progressEntry -> ((ChannelMemory.FileProgress)progressEntry.getValue()).setFinished(Boolean.FALSE));
            try {
                File memoryFile = new File(this.basePath + "/milog/memory/channel_" + String.valueOf(memoryEntry.getKey()));
                FileWriter writer = new FileWriter(memoryFile, false);
                writer.append(gson.toJson((Object)channelMemory));
                writer.flush();
            }
            catch (Throwable e) {
                log.error("flush2disk error, channelId:{}", (Object)channelMemory.getChannelId(), (Object)e);
            }
        });
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Input.class, (Object)new AbstractElementAdapter());
        gson = gsonBuilder.create();
    }
}

