/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.env;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.model.vo.HeraAppEnvVo;
import org.apache.ozhera.app.model.vo.PodInfo;
import org.apache.ozhera.app.service.env.EnvIpFetch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class DefaultHttpEnvIpFetch
implements EnvIpFetch {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpEnvIpFetch.class);
    @NacosValue(value="${hera.operator.env.url}", autoRefreshed=true)
    private String operatorEnvUrl;
    @Resource
    private OkHttpClient okHttpClient;
    @Resource
    private Gson gson;

    @Override
    public HeraAppEnvVo fetch(Long appBaseId, Long appId, String appName) throws Exception {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", appName);
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)this.gson.toJson((JsonElement)jsonObject));
        Request request = new Request.Builder().url(String.format("%s%s", this.operatorEnvUrl, Constant.URL.HERA_OPERATOR_ENV_URL)).post(requestBody).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            String rstJson = response.body().string();
            log.info("HeraAppEnvVo fetch,result:{}", (Object)rstJson);
            Result result = (Result)this.gson.fromJson(rstJson, new TypeToken<Result<Map<String, List<PodInfo>>>>(this){}.getType());
            return this.generateHeraAppEnvVo(appBaseId, appId, appName, (Map)result.getData());
        }
        return null;
    }

    private HeraAppEnvVo generateHeraAppEnvVo(Long heraAppId, Long appId, String appName, Map<String, List<PodInfo>> resultMap) {
        List envVos = resultMap.entrySet().stream().map(entry -> {
            HeraAppEnvVo.EnvVo envVo = new HeraAppEnvVo.EnvVo();
            envVo.setEnvId(Long.valueOf(((PodInfo)((List)entry.getValue()).get(0)).getEnvId()));
            envVo.setEnvName((String)entry.getKey());
            envVo.setIpList(((List)entry.getValue()).stream().map(PodInfo::getIp).collect(Collectors.toList()));
            return envVo;
        }).collect(Collectors.toList());
        return HeraAppEnvVo.builder().heraAppId(heraAppId).appId(appId).appName(appName).envVos(envVos).build();
    }
}

