/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mybatisplus;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.xiaomi.youpin.docean.Aop;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.common.ClassPathResource;
import com.xiaomi.youpin.docean.common.Resource;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.datasource.DatasourceConfig;
import com.xiaomi.youpin.docean.plugin.mybatisplus.SqlSessionFactoryBean;
import com.xiaomi.youpin.docean.plugin.mybatisplus.Transactional;
import com.xiaomi.youpin.docean.plugin.mybatisplus.TransactionalContext;
import com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor.InterceptorForQryAndUpdate;
import com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor.InterceptorFunction;
import com.xiaomi.youpin.docean.plugin.mybatisplus.interceptor.TransactionalInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@DOceanPlugin(order=0x7FFFFFFE)
public class MybatisPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlugin.class);
    public static final String MY_BATIS_MESH_INTERCEPTORNAME = "mybatisMeshInterceptor";
    public static final String MYBATIS_MAPPER_LOCATION = "mybatis_mapper_location";

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        log.info("mybatis plugin init");
        Aop.ins().getInterceptorMap().put(Transactional.class, new TransactionalInterceptor());
        Config config = (Config)ioc.getBean(Config.class);
        List dbNames = (List)ioc.getBean("DB_NAMES");
        boolean one = dbNames.size() == 1;
        dbNames.stream().forEach(it -> this.addDAO(ioc, (String)it, config.get(MYBATIS_MAPPER_LOCATION, ""), one));
    }

    private void addDAO(Ioc ioc, String beanName, String mapperLocation, boolean one) {
        Object dataSource = ioc.getBean(beanName);
        if (dataSource instanceof DataSource) {
            Set plusInterceptors;
            SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
            bean.setDataSource((DataSource)dataSource);
            Object[] mapperList = mapperLocation.split(",");
            log.info("mapperLocation is [{}]", mapperList);
            if (mapperList == null || mapperList.length == 0) {
                log.info("mapper path is empty");
                return;
            }
            Resource[] array = new Resource[mapperList.length];
            for (int i = 0; i < mapperList.length; ++i) {
                array[i] = new ClassPathResource(((String)mapperList[i]).trim());
                log.info("mapper local is [{}]", (Object)((String)mapperList[i]).trim());
            }
            bean.setMapperLocations(array);
            DatasourceConfig config = (DatasourceConfig)ioc.getBean(beanName + "_config");
            if (ioc.containsBean(MY_BATIS_MESH_INTERCEPTORNAME)) {
                InterceptorFunction function = (InterceptorFunction)ioc.getBean(MY_BATIS_MESH_INTERCEPTORNAME);
                InterceptorForQryAndUpdate interceptor = new InterceptorForQryAndUpdate(function);
                interceptor.setDatasourceConfig(config);
                bean.setPlugins(new Interceptor[]{interceptor});
            }
            if (!CollectionUtils.isEmpty((Collection)(plusInterceptors = ioc.getBeans(MybatisPlusInterceptor.class)))) {
                bean.setPlugins(plusInterceptors.toArray(new Interceptor[0]));
            }
            SqlSessionFactory factory = bean.buildSqlSessionFactory();
            ioc.putBean("mybatis_" + beanName + config.getName(), (Object)factory);
            Collection mappers = factory.getConfiguration().getMapperRegistry().getMappers();
            mappers.forEach(it -> {
                Object proxy = factory.getConfiguration().getMapperRegistry().getMapper(it, (SqlSession)Proxy.newProxyInstance(SqlSessionFactory.class.getClassLoader(), new Class[]{SqlSession.class}, (InvocationHandler)new SqlSessionInterceptor(this, factory)));
                Object name = it.getName();
                if (!one) {
                    name = it.getSimpleName() + ":" + config.getName();
                }
                log.info("mybatis dao name:{} add", name);
                ioc.putBean((String)name, proxy);
            });
        }
    }

    public String version() {
        return "0.0.1:2021-03-03";
    }

    private class SqlSessionInterceptor
    implements InvocationHandler {
        private SqlSessionFactory sqlSessionFactory;

        private SqlSessionInterceptor(MybatisPlugin mybatisPlugin, SqlSessionFactory sqlSessionFactory) {
            this.sqlSessionFactory = sqlSessionFactory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SqlSession sqlSession = null;
            try {
                if (TransactionalContext.getTransactionActive() != null && TransactionalContext.getTransactionActive().booleanValue()) {
                    if (TransactionalContext.getSqlSession() != null) {
                        Object result;
                        sqlSession = TransactionalContext.getSqlSession();
                        Object object = result = method.invoke((Object)sqlSession, args);
                        return object;
                    }
                    sqlSession = this.sqlSessionFactory.openSession(false);
                    Object result = method.invoke((Object)sqlSession, args);
                    TransactionalContext.setSqlSession(sqlSession);
                    Object object = result;
                    return object;
                }
                sqlSession = this.sqlSessionFactory.openSession(true);
                Object result = method.invoke((Object)sqlSession, args);
                sqlSession.commit(true);
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
                throw unwrapped;
            }
            finally {
                if (!(TransactionalContext.getTransactionActive() != null && TransactionalContext.getTransactionActive().booleanValue() || sqlSession == null)) {
                    sqlSession.close();
                }
            }
        }
    }
}

