/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmStrategyInfo;
import org.apache.ozhera.monitor.bo.AlarmStrategyType;
import org.apache.ozhera.monitor.dao.AppAlarmStrategyDao;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.user.UserConfigService;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.util.Daos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Repository;

@Repository
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class AppAlarmStrategyDaoImpl
implements AppAlarmStrategyDao {
    private static final Logger log = LoggerFactory.getLogger(AppAlarmStrategyDaoImpl.class);
    @Autowired
    private Dao dao;
    @Autowired
    UserConfigService userConfigService;

    @Override
    public AlarmStrategy getById(Integer id) {
        return (AlarmStrategy)this.dao.fetch(AlarmStrategy.class, (long)id.intValue());
    }

    @Override
    public List<AlarmStrategy> queryByType(int type) {
        return this.dao.query(AlarmStrategy.class, (Condition)Cnd.where((String)"strategy_type", (String)"=", (Object)3).and("group3", "=", (Object)""));
    }

    @Override
    public AlarmStrategyInfo getInfoById(Integer id) {
        return this.buildAlarmStrategyInfo(this.getById(id));
    }

    @Override
    public boolean insert(AlarmStrategy strategy) {
        if (strategy.getCreateTime() == null) {
            strategy.setCreateTime(new Date());
        }
        if (strategy.getUpdateTime() == null) {
            strategy.setUpdateTime(new Date());
        }
        if (strategy.getStatus() == null) {
            strategy.setStatus(0);
        }
        if (strategy.getStrategyType() == null) {
            strategy.setStrategyType(0);
        }
        if (StringUtils.isBlank((CharSequence)strategy.getGroup3())) {
            strategy.setGroup3("");
        }
        if (StringUtils.isBlank((CharSequence)strategy.getGroup4())) {
            strategy.setGroup4("");
        }
        if (StringUtils.isBlank((CharSequence)strategy.getGroup5())) {
            strategy.setGroup5("");
        }
        try {
            return this.dao.insert((Object)strategy) != null;
        }
        catch (Exception e) {
            log.error("appAlarmStrategy\u8868\u63d2\u5165\u5f02\u5e38\uff1b strategy={}", (Object)strategy, (Object)e);
            return false;
        }
    }

    @Override
    public boolean updateById(AlarmStrategy strategy) {
        if (strategy.getUpdateTime() == null) {
            strategy.setUpdateTime(new Date());
        }
        try {
            return this.dao.updateIgnoreNull((Object)strategy) > 0;
        }
        catch (Exception e) {
            log.error("appAlarmStrategy\u8868\u66f4\u65b0\u5f02\u5e38\uff1b strategy={}", (Object)strategy, (Object)e);
            return false;
        }
    }

    @Override
    public boolean deleteById(Integer id) {
        try {
            return this.dao.delete(AlarmStrategy.class, (long)id.intValue()) > 0;
        }
        catch (Exception e) {
            log.error("appAlarmStrategy\u8868\u5220\u9664\u5f02\u5e38\uff1b id={}", (Object)id, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageData<List<AlarmStrategyInfo>> searchByCond(final String user, Boolean filterOwner, AlarmStrategy strategy, int page, int pageSize, String sortBy, String sortRule) {
        log.info("AppAlarmStrategyDao.searchByCond strategy={}, page={}, pageSize={}", new Object[]{strategy, page, pageSize});
        PageData<List<AlarmStrategyInfo>> pageData = new PageData<List<AlarmStrategyInfo>>();
        pageData.setPage(page);
        pageData.setPageSize(pageSize);
        try {
            long totalCount;
            StringBuilder sqlB = new StringBuilder();
            sqlB.append("select an.id").append(",an.iamId").append(",an.appId").append(",an.appName").append(",an.strategy_type").append(",an.strategy_name").append(",an.desc").append(",an.creater").append(",an.status").append(",an.alert_team").append(",an.create_time").append(",an.update_time").append(",an.group3").append(",an.group4").append(",an.group5").append(",an.envs,an.alert_members,at_members");
            if (strategy.getStrategyType() != null && strategy.getStrategyType().equals(AlarmStrategyType.TESLA.getCode())) {
                sqlB.append(",an.creater as owner  from app_alarm_strategy an where 1=1 ");
                if (!this.userConfigService.isAdmin(user)) {
                    StringBuilder builder = new StringBuilder();
                    if (StringUtils.isNotBlank((CharSequence)strategy.getGroup3())) {
                        builder.append(" an.group3='").append(strategy.getGroup3()).append("'");
                    }
                    if (StringUtils.isNotBlank((CharSequence)strategy.getGroup4())) {
                        builder.append(" and an.group4='").append(strategy.getGroup4()).append("'");
                    }
                    if (StringUtils.isNotBlank((CharSequence)strategy.getGroup5())) {
                        builder.append(" and an.group5='").append(strategy.getGroup5()).append("'");
                    }
                    if (builder.length() > 0) {
                        sqlB.append("and ((");
                        sqlB.append(builder.toString());
                        sqlB.append(")");
                        sqlB.append(" or creater=");
                        sqlB.append("@user");
                        sqlB.append(") ");
                    } else {
                        sqlB.append("and creater=");
                        sqlB.append("@user");
                    }
                }
            } else {
                sqlB.append(",app.owner").append(" from ").append("app_alarm_strategy an left join app_monitor app on an.appId=app.project_id").append(" where app.status=0 ");
                if (filterOwner != null && filterOwner.booleanValue()) {
                    sqlB.append(" and app.owner=").append("@user");
                } else {
                    sqlB.append(" and (app.owner=").append("@user").append(" or app.care_user=").append("@user").append(")");
                }
            }
            if (strategy.getStatus() != null) {
                sqlB.append(" and an.status=").append(strategy.getStatus());
            }
            if (strategy.getAppId() != null) {
                sqlB.append(" and an.appId=").append(strategy.getAppId());
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getAppName())) {
                sqlB.append(" and an.appName LIKE ").append("@appName");
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getCreater())) {
                sqlB.append(" and an.creater=").append("@creater");
            }
            if (strategy.getStrategyType() != null) {
                sqlB.append(" and an.strategy_type=").append(strategy.getStrategyType());
            } else {
                sqlB.append(" and an.strategy_type!=").append(AlarmStrategyType.TESLA.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getStrategyName())) {
                sqlB.append(" and an.strategy_name LIKE ").append("@strategyName");
            }
            if (StringUtils.isNotBlank((CharSequence)sortBy) && StringUtils.isNotBlank((CharSequence)sortRule)) {
                sqlB.append(" order by an.").append(sortBy).append(" ").append(sortRule);
            } else {
                log.info("Alarm strategy searchByCond no order info assign! use default order");
                sqlB.append(" order by an.id desc");
            }
            Sql sql = Sqls.create((String)sqlB.toString()).setParam("user", (Object)user).setParam("creater", (Object)strategy.getCreater());
            if (StringUtils.isNotBlank((CharSequence)strategy.getAppName())) {
                sql = sql.setParam("appName", (Object)("%" + strategy.getAppName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getStrategyName())) {
                sql = sql.setParam("strategyName", (Object)("%" + strategy.getStrategyName() + "%"));
            }
            if ((totalCount = Daos.queryCount((Dao)this.dao, (Sql)sql)) <= 0L) {
                pageData.setTotal(0L);
                PageData<List<AlarmStrategyInfo>> pageData2 = pageData;
                return pageData2;
            }
            log.info("searchByCond# sql:{}", (Object)sql);
            pageData.setTotal(totalCount);
            sql.setPager(new Pager(page, pageSize));
            sql.setCallback(new SqlCallback(){

                public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                    ArrayList<AlarmStrategyInfo> list = new ArrayList<AlarmStrategyInfo>();
                    while (rs.next()) {
                        AlarmStrategyInfo info = new AlarmStrategyInfo();
                        info.setId(rs.getInt("id"));
                        Timestamp date = rs.getTimestamp("update_time");
                        if (date != null) {
                            info.setUpdateTime(((Date)date).getTime());
                        }
                        if ((date = rs.getTimestamp("create_time")) != null) {
                            info.setCreateTime(((Date)date).getTime());
                        }
                        Integer strategyType = rs.getInt("strategy_type");
                        info.setAppId(rs.getInt("appId"));
                        info.setAppName(rs.getString("appName"));
                        info.setStrategyName(rs.getString("strategy_name"));
                        info.setAlertTeam(rs.getString("alert_team"));
                        info.setStrategyType(strategyType);
                        info.setCreater(rs.getString("creater"));
                        info.setStrategyDesc(rs.getString("desc"));
                        info.setStatus(rs.getInt("status"));
                        info.setIamId(rs.getInt("iamId"));
                        String owner = rs.getString("owner");
                        if (AlarmStrategyType.TESLA.getCode().equals(strategyType)) {
                            if (user.equals(rs.getString("creater"))) {
                                info.setOwner(true);
                            } else {
                                info.setOwner(false);
                            }
                        } else if (user.equals(owner)) {
                            info.setOwner(true);
                        } else {
                            info.setOwner(false);
                        }
                        String envs = rs.getString("envs");
                        info.convertEnvList(envs);
                        String alertMembers = rs.getString("alert_members");
                        info.setAlertMembers(StringUtils.isBlank((CharSequence)alertMembers) ? null : Arrays.asList(alertMembers.split(",")));
                        String atMembers = rs.getString("at_members");
                        info.setAtMembers(StringUtils.isBlank((CharSequence)atMembers) ? null : Arrays.asList(atMembers.split(",")));
                        list.add(info);
                    }
                    return list;
                }
            });
            this.dao.execute(sql);
            pageData.setList(sql.getList(AlarmStrategyInfo.class));
            PageData<List<AlarmStrategyInfo>> pageData3 = pageData;
            return pageData3;
        }
        catch (Exception e) {
            log.error("appAlarmStrategy\u8868\u67e5\u8be2\u5f02\u5e38\uff1b strategy={}", (Object)strategy, (Object)e);
            pageData.setTotal(0L);
            PageData<List<AlarmStrategyInfo>> pageData4 = pageData;
            return pageData4;
        }
        finally {
            log.info("AppAlarmStrategyDao.searchByCond.result pageData={}", pageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public PageData<List<AlarmStrategyInfo>> searchByCondNoUser(AlarmStrategy strategy, int page, int pageSize, String sortBy, String sortRule) {
        log.info("AppAlarmStrategyDao.searchWashData strategy={}, page={}, pageSize={}", new Object[]{strategy, page, pageSize});
        PageData<List<AlarmStrategyInfo>> pageData = new PageData<List<AlarmStrategyInfo>>();
        pageData.setPage(page);
        pageData.setPageSize(pageSize);
        try {
            long totalCount;
            StringBuilder sqlB = new StringBuilder();
            sqlB.append("select an.id").append(",an.iamId").append(",an.appId").append(",an.appName").append(",an.strategy_type").append(",an.strategy_name").append(",an.desc").append(",an.creater").append(",an.status").append(",an.alert_team").append(",an.create_time").append(",an.update_time").append(",an.group3").append(",an.group4").append(",an.group5").append(",an.envs,an.alert_members,at_members");
            sqlB.append(" from ").append("app_alarm_strategy an ").append(" where 1=1 ");
            if (strategy.getStatus() != null) {
                sqlB.append(" and an.status=").append(strategy.getStatus());
            }
            if (strategy.getAppId() != null) {
                sqlB.append(" and an.appId=").append(strategy.getAppId());
            }
            if (strategy.getIamId() != null) {
                sqlB.append(" and an.iamId=").append(strategy.getIamId());
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getAppName())) {
                sqlB.append(" and an.appName = ").append("@appName");
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getCreater())) {
                sqlB.append(" and an.creater=@creater");
            }
            if (strategy.getStrategyType() != null) {
                sqlB.append(" and an.strategy_type=").append(strategy.getStrategyType());
            } else {
                sqlB.append(" and an.strategy_type!=").append(AlarmStrategyType.TESLA.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)strategy.getStrategyName())) {
                sqlB.append(" and an.strategy_name LIKE ").append("@strategyName");
            }
            if (StringUtils.isNotBlank((CharSequence)sortBy) && StringUtils.isNotBlank((CharSequence)sortRule)) {
                sqlB.append(" order by an.").append(sortBy).append(" ").append(sortRule);
            } else {
                log.info("Alarm strategy searchByCond no order info assign! use default order");
                sqlB.append(" order by an.id desc");
            }
            Sql sql = Sqls.create((String)sqlB.toString()).setParam("creater", (Object)strategy.getCreater()).setParam("appName", (Object)strategy.getAppName());
            if (StringUtils.isNotBlank((CharSequence)strategy.getStrategyName())) {
                sql = sql.setParam("strategyName", (Object)("%" + strategy.getStrategyName() + "%"));
            }
            if ((totalCount = Daos.queryCount((Dao)this.dao, (Sql)sql)) <= 0L) {
                pageData.setTotal(0L);
                PageData<List<AlarmStrategyInfo>> pageData2 = pageData;
                return pageData2;
            }
            pageData.setTotal(totalCount);
            sql.setPager(new Pager(page, pageSize));
            sql.setCallback(new SqlCallback(){

                public Object invoke(Connection conn, ResultSet rs, Sql sql) throws SQLException {
                    ArrayList<AlarmStrategyInfo> list = new ArrayList<AlarmStrategyInfo>();
                    while (rs.next()) {
                        AlarmStrategyInfo info = new AlarmStrategyInfo();
                        info.setId(rs.getInt("id"));
                        Timestamp date = rs.getTimestamp("update_time");
                        if (date != null) {
                            info.setUpdateTime(((Date)date).getTime());
                        }
                        if ((date = rs.getTimestamp("create_time")) != null) {
                            info.setCreateTime(((Date)date).getTime());
                        }
                        Integer strategyType = rs.getInt("strategy_type");
                        info.setAppId(rs.getInt("appId"));
                        info.setAppName(rs.getString("appName"));
                        info.setStrategyName(rs.getString("strategy_name"));
                        info.setAlertTeam(rs.getString("alert_team"));
                        info.setStrategyType(strategyType);
                        info.setCreater(rs.getString("creater"));
                        info.setStrategyDesc(rs.getString("desc"));
                        info.setStatus(rs.getInt("status"));
                        info.setIamId(rs.getInt("iamId"));
                        String envs = rs.getString("envs");
                        info.convertEnvList(envs);
                        String alertMembers = rs.getString("alert_members");
                        info.setAlertMembers(StringUtils.isBlank((CharSequence)alertMembers) ? null : Arrays.asList(alertMembers.split(",")));
                        String atMembers = rs.getString("at_members");
                        info.setAtMembers(StringUtils.isBlank((CharSequence)atMembers) ? null : Arrays.asList(atMembers.split(",")));
                        list.add(info);
                    }
                    return list;
                }
            });
            this.dao.execute(sql);
            pageData.setList(sql.getList(AlarmStrategyInfo.class));
            PageData<List<AlarmStrategyInfo>> pageData3 = pageData;
            return pageData3;
        }
        catch (Exception e) {
            log.error("appAlarmStrategy\u8868\u67e5\u8be2\u5f02\u5e38\uff1b strategy={}", (Object)strategy, (Object)e);
            pageData.setTotal(0L);
            PageData<List<AlarmStrategyInfo>> pageData4 = pageData;
            return pageData4;
        }
        finally {
            log.info("AppAlarmStrategyDao.searchByCond.result pageData={}", pageData);
        }
    }

    private AlarmStrategyInfo buildAlarmStrategyInfo(AlarmStrategy strategy) {
        if (strategy == null) {
            return null;
        }
        AlarmStrategyInfo info = new AlarmStrategyInfo();
        BeanUtils.copyProperties((Object)strategy, (Object)info);
        if (strategy.getCreateTime() != null) {
            info.setCreateTime(strategy.getCreateTime().getTime());
        }
        if (strategy.getUpdateTime() != null) {
            info.setUpdateTime(strategy.getUpdateTime().getTime());
        }
        info.setStrategyDesc(strategy.getDesc());
        info.convertEnvList(strategy.getEnvs());
        info.setAlertMembers(StringUtils.isBlank((CharSequence)strategy.getAlertMembers()) ? null : Arrays.asList(strategy.getAlertMembers().split(",")));
        info.setAtMembers(StringUtils.isBlank((CharSequence)strategy.getAtMembers()) ? null : Arrays.asList(strategy.getAtMembers().split(",")));
        return info;
    }
}

