/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.helper;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.BasicUrlType;
import org.apache.ozhera.monitor.bo.MetricsUnit;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.pojo.AlarmPresetMetricsPOJO;
import org.apache.ozhera.monitor.service.api.AlarmPresetMetricsService;
import org.apache.ozhera.monitor.service.api.AlertHelperExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class AlertHelperExtensionImpl
implements AlertHelperExtension {
    private static final Logger log = LoggerFactory.getLogger(AlertHelperExtensionImpl.class);
    @NacosValue(value="${hera.dash.url}", autoRefreshed=true)
    private String heraDashUrl;
    @NacosValue(value="${cn.grafana.url}", autoRefreshed=true)
    private String cnGrafanaUrl;
    @NacosValue(value="${cn.grafana.disk_rate.url}", autoRefreshed=true)
    private String cnGrafanaDiskRateUrl;
    @Autowired
    private AlarmPresetMetricsService alarmPresetMetricsService;

    @Override
    public void buildAlertContent(StringBuilder content, JsonObject data) {
        if (!(data.has("alert_key") && data.has("alert_op") && data.has("alert_value"))) {
            return;
        }
        AlarmPresetMetricsPOJO metrics = this.alarmPresetMetricsService.getByCode(data.get("alert_key").getAsString());
        if (metrics == null) {
            return;
        }
        content.append(metrics.getMessage()).append(" ").append(data.get("alert_op").getAsString()).append(" ").append(data.get("alert_value").getAsString());
        if (MetricsUnit.UNIT_PERCENT.equals((Object)metrics.getUnit())) {
            content.append("%");
        }
        content.append(", ");
    }

    @Override
    public void buildDetailRedirectUrl(String user, AppMonitor app, String alert, JsonObject jsonSummary, JsonObject labels) {
        if (labels == null) {
            return;
        }
        if (labels.has("detailRedirectUrl")) {
            log.info("\u6307\u6807{}\u5df2\u7ecf\u5305\u542bdetailRedirectUrl={}", (Object)alert, (Object)labels);
            return;
        }
        AlarmPresetMetricsPOJO metric = this.alarmPresetMetricsService.getByCode(alert);
        if (metric == null || metric.getBasicUrlType() == null) {
            return;
        }
        labels.addProperty("ip", "{{$labels.ip}}");
        labels.addProperty("serverIp", "{{$labels.serverIp}}");
        labels.addProperty("job", "{{$labels.job}}");
        labels.addProperty("group", "{{$labels.group}}");
        if ((BasicUrlType.hera_dash_ip.getName().equals(metric.getBasicUrlType().getName()) || BasicUrlType.hera_dash_sip.getName().equals(metric.getBasicUrlType().getName())) && StringUtils.isNotBlank((CharSequence)this.heraDashUrl)) {
            JsonObject json;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", app.getProjectId());
            params.put("name", app.getProjectName());
            String url = this.buildUrl(this.heraDashUrl, metric, params);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                labels.addProperty("detailRedirectUrl", url);
            }
            if ((json = metric.getBasicUrlType().getReqJsonObject()) != null) {
                jsonSummary.addProperty("paramMapping", json.toString());
                labels.addProperty("paramType", "normal");
            }
        } else if ((BasicUrlType.cn_grafana_ip.getName().equals(metric.getBasicUrlType().getName()) || BasicUrlType.cn_grafana_sip.getName().equals(metric.getBasicUrlType().getName()) || BasicUrlType.cn_grafana_ip_1d.getName().equals(metric.getBasicUrlType().getName()) || BasicUrlType.cn_grafana_sip_1d.getName().equals(metric.getBasicUrlType().getName())) && StringUtils.isNotBlank((CharSequence)this.cnGrafanaUrl)) {
            JsonObject json;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgId", 1);
            params.put("refresh", "10s");
            String url = this.buildUrl(this.cnGrafanaUrl, metric, params);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                labels.addProperty("detailRedirectUrl", url);
            }
            if ((json = metric.getBasicUrlType().getReqJsonObject()) != null) {
                jsonSummary.addProperty("paramMapping", json.toString());
                labels.addProperty("paramType", "normal");
            }
        } else if (BasicUrlType.cn_grafana_disk_rate.getName().equals(metric.getBasicUrlType().getName()) && StringUtils.isNotBlank((CharSequence)this.cnGrafanaDiskRateUrl)) {
            JsonObject json;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgId", 1);
            String url = this.buildUrl(this.cnGrafanaDiskRateUrl, metric, params);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                labels.addProperty("detailRedirectUrl", url);
            }
            if ((json = metric.getBasicUrlType().getReqJsonObject()) != null) {
                jsonSummary.addProperty("paramMapping", json.toString());
                labels.addProperty("paramType", "normal");
            }
        }
    }

    private String buildUrl(String url, AlarmPresetMetricsPOJO metric, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        StringBuilder urlB = new StringBuilder();
        urlB.append(url);
        int pod = url.lastIndexOf(63);
        if (pod < 0) {
            urlB.append("?");
        } else {
            urlB.append("&");
        }
        if (params != null && !params.isEmpty()) {
            params.entrySet().stream().forEach(entry -> urlB.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&"));
        }
        if (StringUtils.isNotBlank((CharSequence)metric.getEnv())) {
            urlB.append("var-env=").append(metric.getEnv()).append("&");
        }
        if (StringUtils.isNotBlank((CharSequence)metric.getDomain())) {
            urlB.append("var-domain=").append(metric.getDomain()).append("&");
        }
        if (StringUtils.isNotBlank((CharSequence)metric.getViewPanel())) {
            urlB.append("viewPanel=").append(metric.getViewPanel()).append("&");
        }
        return urlB.substring(0, urlB.length() - 1);
    }

    public String buildUrl(String url, AlarmPresetMetricsPOJO metric) {
        return this.buildUrl(url, metric, null);
    }
}

