/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.user;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.service.user.IdmResponse;
import org.apache.ozhera.monitor.service.user.MoneUserDetailService;
import org.apache.ozhera.monitor.service.user.UseDetailInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;

@Service
public class IdmMoneUserDetailService
implements MoneUserDetailService {
    private static final Logger log = LoggerFactory.getLogger(IdmMoneUserDetailService.class);
    @Value(value="${idm.url:noconfig}")
    private String BASE_IDM_URL;
    @Value(value="${idm.app.id:noconfig}")
    private String IDM_APP_ID;
    @NacosValue(value="${idm.app.key:noconfig}")
    private String IDM_APP_KEY;
    @NacosValue(value="${hera.access.member.white.list:noconfig}", autoRefreshed=true)
    private String accessWhiteList;
    @NacosValue(value="${hera.access.member.black.list:noconfig}", autoRefreshed=true)
    private String accessBlackList;
    @NacosValue(value="${hera.access.dept.black.list:noconfig}", autoRefreshed=true)
    private String accessDeptBlackList;
    @NacosValue(value="${hera.admin.member.list:noconfig}", autoRefreshed=true)
    private String adminMemberList;
    private OkHttpClient httpClient = new OkHttpClient();

    private String queryIdmSignData(Map<String, Object> paramMap) {
        String body = GSON.toJson(paramMap);
        String sign = DigestUtils.md5Hex((String)(this.IDM_APP_ID + body + this.IDM_APP_KEY)).toUpperCase();
        JsonObject json = new JsonObject();
        JsonObject header = new JsonObject();
        header.addProperty("appid", this.IDM_APP_ID);
        header.addProperty("sign", sign);
        json.add("header", (JsonElement)header);
        json.addProperty("body", body);
        return Base64Utils.encodeToString((byte[])json.toString().getBytes());
    }

    @Override
    public UseDetailInfo queryUser(String uId) {
        if (StringUtils.isBlank((CharSequence)uId)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("uid", uId);
        String data = this.queryIdmSignData(paramMap);
        String url = this.BASE_IDM_URL + "/api/user/findUserBaseInfoByUid";
        try {
            Request request = new Request.Builder().url(url).post((RequestBody)new FormBody.Builder().add("data", data).build()).build();
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String rstJson = response.body().string();
                IdmResponse rst = (IdmResponse)GSON.fromJson(rstJson, new TypeToken<IdmResponse<UseDetailInfo>>(this){}.getType());
                if (!rst.getCode().equals(0)) {
                    log.error("IDM query user detail error,please contact them,return value:{}", (Object)rstJson);
                }
                UseDetailInfo detailInfo = (UseDetailInfo)rst.getData();
                List deptDescrs = (List)GSON.fromJson(detailInfo.getFullDeptDescr(), new TypeToken<ArrayList<UseDetailInfo.DeptDescr>>(this){}.getType());
                detailInfo.setFullDeptDescrList(deptDescrs);
                log.info("IDM get userDetail:{}", (Object)GSON.toJson((Object)rst));
                return detailInfo;
            }
            log.info("IDM return data:{}", (Object)response.body().string());
        }
        catch (Exception e) {
            log.error(String.format("IDM query userDetail exception,url:%s,uId:%s,data:{}", url, uId, data), (Throwable)e);
        }
        log.error("IDM query user error,contact us");
        return null;
    }

    @Override
    public String queryUserUIdByPhone(String phone) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("mobile", phone);
        String data = this.queryIdmSignData(paramMap);
        String url = this.BASE_IDM_URL + "/api/account/findUidByMobile";
        try {
            Request request = new Request.Builder().url(url).post((RequestBody)new FormBody.Builder().add("data", data).build()).build();
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String rstJson = response.body().string();
                IdmResponse rst = (IdmResponse)GSON.fromJson(rstJson, new TypeToken<IdmResponse<String>>(this){}.getType());
                log.info("IDM get Uid by phone:{}", (Object)rst);
                return (String)rst.getData();
            }
            log.info("IDM return data by phone:{}", (Object)response.body().string());
        }
        catch (Exception e) {
            log.error(String.format("IDM query userDetail exception,url:%s,phone:%s,data:%s", url, phone, data), (Throwable)e);
        }
        log.error("IDM query userId by phone error,contact us");
        return null;
    }

    @Override
    public String queryUserUIdByEmpId(String empId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personId", empId);
        String data = this.queryIdmSignData(paramMap);
        String url = this.BASE_IDM_URL + "/api/user/findUidByPersonId";
        try {
            Request request = new Request.Builder().url(url).post((RequestBody)new FormBody.Builder().add("data", data).build()).build();
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String rstJson = response.body().string();
                IdmResponse rst = (IdmResponse)GSON.fromJson(rstJson, new TypeToken<IdmResponse<String>>(this){}.getType());
                log.info("IDM get Uid by empId:{}", (Object)rstJson);
                return (String)rst.getData();
            }
            log.info("IDM return data by empId:{}", (Object)response.body().string());
        }
        catch (Exception e) {
            log.error(String.format("IDM query userDetail exception,url:%s,empId:%s,data:%s", url, empId, data), (Throwable)e);
        }
        log.error("IDM query userId by empId error,contact us");
        return null;
    }

    @Override
    public String queryUserUIdByUsername(String username) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userName", username);
        String data = this.queryIdmSignData(paramMap);
        String url = this.BASE_IDM_URL + "/api/account/findUidByUserName";
        try {
            Request request = new Request.Builder().url(url).post((RequestBody)new FormBody.Builder().add("data", data).build()).build();
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String rstJson = response.body().string();
                IdmResponse rst = (IdmResponse)GSON.fromJson(rstJson, new TypeToken<IdmResponse<String>>(this){}.getType());
                log.info("IDM get Uid by username:{}", (Object)rstJson);
                return (String)rst.getData();
            }
            log.info("IDM return data by username:{}", (Object)response.body().string());
        }
        catch (Exception e) {
            log.error(String.format("IDM query userDetail exception,url:%s,username:%s,data:%s", url, username, data), (Throwable)e);
        }
        log.error("IDM query userId by username error,contact us");
        return null;
    }

    @Override
    public List<String> getWhiteList() {
        if (StringUtils.isBlank((CharSequence)this.accessWhiteList)) {
            return Lists.newArrayList();
        }
        String[] members = this.accessWhiteList.split(",");
        return Arrays.asList(members);
    }

    @Override
    public List<String> getBlackList() {
        if (StringUtils.isBlank((CharSequence)this.accessBlackList)) {
            return Lists.newArrayList();
        }
        String[] members = this.accessBlackList.split(",");
        return Arrays.asList(members);
    }

    @Override
    public List<String> getDeptBlackList() {
        if (StringUtils.isBlank((CharSequence)this.accessDeptBlackList)) {
            return Lists.newArrayList();
        }
        String[] depts = this.accessDeptBlackList.split(",");
        return Arrays.asList(depts);
    }

    @Override
    public List<String> getAdminUserList() {
        if (StringUtils.isBlank((CharSequence)this.adminMemberList)) {
            return Lists.newArrayList();
        }
        String[] admins = this.adminMemberList.split(",");
        return Arrays.asList(admins);
    }
}

