/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.bootstrap;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin
public class LogStoragePlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(LogStoragePlugin.class);
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;
    @Value(value="$driver.class")
    private String driverClass;
    private static final String ADDR_PREFIX = "http://";

    public void init() {
        log.info("es init start");
        List<MilogEsClusterDO> esClusterList = this.milogEsClusterMapper.selectAll();
        if (esClusterList == null || esClusterList.isEmpty()) {
            log.warn("no Log storage type");
            return;
        }
        for (MilogEsClusterDO cluster : esClusterList) {
            this.initializeLogStorage(cluster);
        }
    }

    public void initializeLogStorage(MilogEsClusterDO cluster) {
        LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)cluster.getLogStorageType());
        try {
            if (null == storageTypeEnum || LogStorageTypeEnum.ELASTICSEARCH == storageTypeEnum) {
                this.checkAddrUpdate(cluster);
                EsService esService = this.createEsService(cluster);
                this.registerEsService(cluster, esService);
                log.info("ES client[{}]Generated successfully[{}]", (Object)cluster.getName(), (Object)(Constant.LOG_STORAGE_SERV_BEAN_PRE + cluster.getId()));
            } else if (LogStorageTypeEnum.DORIS == storageTypeEnum) {
                DataSource dataSource = this.createDorisDataSource(cluster);
                this.registerDorisDataSource(cluster, dataSource);
                log.info("doris dataSource[{}]Generated successfully[{}]", (Object)cluster.getName(), (Object)(Constant.LOG_STORAGE_SERV_BEAN_PRE + cluster.getId()));
            }
        }
        catch (Exception e) {
            log.error("init storage client error,cluster{}", (Object)Constant.GSON.toJson((Object)cluster), (Object)e);
        }
    }

    private EsService createEsService(MilogEsClusterDO cluster) {
        switch (cluster.getConWay()) {
            case "pwd": {
                return new EsService(cluster.getAddr(), cluster.getUser(), cluster.getPwd());
            }
            case "token": {
                return new EsService(cluster.getAddr(), cluster.getToken(), cluster.getDtCatalog(), cluster.getDtDatabase());
            }
        }
        log.warn("The ES cluster entered an exception: [{}]", (Object)cluster);
        throw new IllegalArgumentException("Invalid ES connection way");
    }

    private void registerEsService(MilogEsClusterDO cluster, EsService esService) {
        Ioc.ins().putBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + cluster.getId(), (Object)esService);
    }

    private DataSource createDorisDataSource(MilogEsClusterDO cluster) {
        String addr = cluster.getAddr();
        PooledDataSource pooledDataSource = new PooledDataSource(this.driverClass, addr, cluster.getUser(), cluster.getPwd());
        pooledDataSource.setPoolPingEnabled(true);
        pooledDataSource.setPoolPingQuery("SELECT 1");
        pooledDataSource.setPoolMaximumActiveConnections(20);
        return pooledDataSource;
    }

    private void registerDorisDataSource(MilogEsClusterDO cluster, DataSource dataSource) {
        Ioc.ins().putBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + cluster.getId(), (Object)dataSource);
    }

    private void checkAddrUpdate(MilogEsClusterDO cluster) {
        String addr = cluster.getAddr();
        if (addr.startsWith(ADDR_PREFIX)) {
            cluster.setAddr(addr.substring(ADDR_PREFIX.length() + 1));
        }
    }
}

