/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller;

import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.anno.RequestParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.model.vo.TailLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.model.MilogSpaceParam;
import org.apache.ozhera.log.manager.model.bo.BatchQueryParam;
import org.apache.ozhera.log.manager.model.bo.LogTailParam;
import org.apache.ozhera.log.manager.model.bo.MlogParseParam;
import org.apache.ozhera.log.manager.model.dto.AppTypeTailDTO;
import org.apache.ozhera.log.manager.model.dto.LogStoreDTO;
import org.apache.ozhera.log.manager.model.dto.LogTailDTO;
import org.apache.ozhera.log.manager.model.dto.MapDTO;
import org.apache.ozhera.log.manager.model.dto.MenuDTO;
import org.apache.ozhera.log.manager.model.dto.MilogAppEnvDTO;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceDTO;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceTreeDTO;
import org.apache.ozhera.log.manager.model.dto.UnAccessAppDTO;
import org.apache.ozhera.log.manager.model.dto.ValueDTO;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.vo.LogStoreParam;
import org.apache.ozhera.log.manager.model.vo.QuickQueryVO;
import org.apache.ozhera.log.manager.service.HeralogHomePageService;
import org.apache.ozhera.log.manager.service.impl.LogProcessServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogSpaceServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogStoreServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;

@Controller
public class MilogConfigController {
    @Resource
    private LogSpaceServiceImpl logSpaceService;
    @Resource
    private LogStoreServiceImpl logStoreService;
    @Resource
    private LogTailServiceImpl logTailService;
    @Resource
    private HeralogHomePageService heralogHomePageService;
    @Resource
    private LogProcessServiceImpl logProcessService;

    @RequestMapping(path="/milog/space/new")
    public Result<String> newMilogSpace(MilogSpaceParam cmd) {
        return this.logSpaceService.newMilogSpace(cmd);
    }

    @RequestMapping(path="/milog/space/getbyid", method="get")
    public Result<MilogSpaceDTO> getMilogSpaceById(@RequestParam(value="id") Long id) {
        return this.logSpaceService.getMilogSpaceById(id);
    }

    @RequestMapping(path="/milog/space/getall", method="get")
    public Result<List<MapDTO<String, Long>>> getMilogSpaces(@RequestParam(value="tenantId") Long tenantId) {
        return this.logSpaceService.getMilogSpaces(tenantId);
    }

    @RequestMapping(path="/milog/space/getbypage", method="get")
    public Result<PageInfo<MilogSpaceDTO>> getMilogSpaceByPage(@RequestParam(value="spaceName") String spaceName, @RequestParam(value="tenantId") Long tenantId, @RequestParam(value="page") Integer page, @RequestParam(value="pageSize") Integer pageSize) {
        return this.logSpaceService.getMilogSpaceByPage(spaceName, tenantId, page, pageSize);
    }

    @RequestMapping(path="/milog/space/delete", method="get")
    public Result<String> deleteMilogSpace(@RequestParam(value="id") Long id) {
        return this.logSpaceService.deleteMilogSpace(id);
    }

    @RequestMapping(path="/milog/space/update")
    public Result<String> updateMilogSpace(@RequestParam(value="param") MilogSpaceParam param) {
        return this.logSpaceService.updateMilogSpace(param);
    }

    @RequestMapping(path="/milog/store/new")
    public Result<String> newLogStore(@RequestParam(value="param") LogStoreParam param) {
        return this.logStoreService.newLogStore(param);
    }

    @RequestMapping(path="/milog/store/getbyid", method="get")
    public Result<LogStoreDTO> getLogStoreById(@RequestParam(value="id") Long id) {
        return this.logStoreService.getLogStoreById(id);
    }

    @RequestMapping(path="/milog/store/getbyids")
    public Result<List<MilogLogStoreDO>> getLogStoreByIds(BatchQueryParam param) throws IOException {
        return this.logStoreService.getLogStoreByIds(param.getIds());
    }

    @RequestMapping(path="/milog/store/getbypage", method="get")
    public Result<Map<String, Object>> getLogStoreByPage(@RequestParam(value="logstoreName") String logstoreName, @RequestParam(value="spaceId") Long spaceId, @RequestParam(value="page") int page, @RequestParam(value="pageSize") int pageSize) {
        return this.logStoreService.getLogStoreByPage(logstoreName, spaceId, page, pageSize);
    }

    @RequestMapping(path="/milog/store/getbyspace", method="get")
    public Result<List<MapDTO<String, Long>>> getLogStoreBySpaceId(@RequestParam(value="spaceId") Long spaceId) {
        return this.logStoreService.getLogStoreBySpaceId(spaceId);
    }

    @RequestMapping(path="/milog/store/getall", method="get")
    public Result<Map<String, Object>> getAllLogStore() {
        return this.logStoreService.getAllLogStore();
    }

    @RequestMapping(path="/milog/store/delete", method="get")
    public Result<Void> deleteLogStore(@RequestParam(value="id") Long id) {
        return this.logStoreService.deleteLogStore(id);
    }

    @RequestMapping(path="/milog/store/log/process", method="get")
    public Result<List<TailLogProcessDTO>> storeLogProcess(@RequestParam(value="type") String type, @RequestParam(value="value") String value) {
        return this.logProcessService.getStoreLogProcess(type, value);
    }

    @RequestMapping(path="/milog/col/process/imperfect", method="get")
    public Result<List<UpdateLogProcessCmd.CollectDetail>> getColProcessImperfect(@RequestParam(value="progressRation") Double progressRation) {
        return this.logProcessService.getColProcessImperfect(progressRation);
    }

    @RequestMapping(path="/milog/store/ips", method="get")
    public Result<List<Map<String, String>>> getStoreIps(@RequestParam(value="storeId") Long storeId) {
        return this.logStoreService.getStoreIps(storeId);
    }

    @RequestMapping(path="/milog/tail/new")
    public Result<LogTailDTO> newLogTail(@RequestParam(value="param") LogTailParam param) {
        return this.logTailService.newMilogLogTail(param);
    }

    @RequestMapping(path="/milog/tail/getbyid", method="get")
    public Result<LogTailDTO> getLogTailById(@RequestParam(value="id") Long id) {
        return this.logTailService.getMilogLogtailById(id);
    }

    @RequestMapping(path="/milog/tail/getbyids", method="get")
    public Result<List<LogTailDTO>> getLogTailByIds(@RequestParam(value="ids") List<Long> ids) {
        return this.logTailService.getMilogLogtailByIds(ids);
    }

    @RequestMapping(path="/milog/tail/getbyStoreId", method="get")
    public Result<List<LogTailDTO>> getTailByStoreId(@RequestParam(value="storeId") Long storeId) {
        return this.logTailService.getTailByStoreId(storeId);
    }

    @RequestMapping(path="/milog/tail/getbypage", method="get")
    public Result<Map<String, Object>> getLogTailByPage(@RequestParam(value="storeId") Long storeId, @RequestParam(value="page") int page, @RequestParam(value="pageSize") int pageSize) throws IOException {
        return this.logTailService.getMilogLogBypage(storeId, page, pageSize);
    }

    @RequestMapping(path="/milog/tail/getcntbystoreid", method="get")
    public Result<Map<String, Object>> getLogTailCountByStoreId(@RequestParam(value="storeId") Long storeId) {
        return this.logTailService.getLogTailCountByStoreId(storeId);
    }

    @RequestMapping(path="/milog/tail/update")
    public Result<Void> updateLogTail(LogTailParam param) {
        return this.logTailService.updateMilogLogTail(param);
    }

    @RequestMapping(path="/milog/tail/delete", method="get")
    public Result<Void> deleteLogTail(@RequestParam(value="id") Long id) {
        return this.logTailService.deleteLogTail(id);
    }

    @RequestMapping(path="/milog/tail/gettailname", method="get")
    public Result<List<String>> getTailNames(@RequestParam(value="id") Long id, @RequestParam(value="appType") Integer appType, @RequestParam(value="tail") String tail) {
        return this.logTailService.getTailNamesBystoreId(tail, appType, id);
    }

    @RequestMapping(path="/milog/tail/tailrate", method="get")
    public Result<List<MapDTO<String, String>>> tailRateLimie() {
        return this.logTailService.tailRatelimit();
    }

    @RequestMapping(path="/milog/tail/getapp", method="get")
    public Result<List<MapDTO>> getAppInfoByName(@RequestParam(value="appName") String appName, @RequestParam(value="type") Integer type) {
        return this.logTailService.getAppInfoByName(appName, type);
    }

    @RequestMapping(path="/milog/tail/app/store/id", method="get")
    public Result<List<MapDTO>> queryAppByStoreId(@RequestParam(value="storeId") Long storeId) {
        return this.logTailService.queryAppByStoreId(storeId);
    }

    @RequestMapping(path="/milog/project/env/appId", method="get")
    public Result<List<MilogAppEnvDTO>> getEnInfosByAppId(@RequestParam(value="milogAppId") Long milogAppId, @RequestParam(value="deployWay") Integer deployWay, @RequestParam(value="machineRoom") String machineRoom) {
        return this.logTailService.getEnInfosByAppId(milogAppId, deployWay, machineRoom);
    }

    @RequestMapping(path="/milog/index/access", method="get")
    public Result<Map<String, Object>> getAccess() {
        return this.heralogHomePageService.milogAccess();
    }

    @RequestMapping(path="/milog/index/getunaccessapp", method="get")
    public Result<List<UnAccessAppDTO>> getUnAccessApp() {
        return this.heralogHomePageService.unAccessAppList();
    }

    @RequestMapping(path="/milog/index/getspacetree", method="get")
    public Result<List<MilogSpaceTreeDTO>> getMilogSpaceTree(@RequestParam(value="spaceId") Long spaceId) {
        return this.heralogHomePageService.getMilogSpaceTree(spaceId);
    }

    @RequestMapping(path="/milog/index/fastaccesslogpattern", method="get")
    public Result<List<ValueDTO<String>>> fastAccessMiloglogPattern() {
        return this.heralogHomePageService.getMiloglogAccessPattern();
    }

    @RequestMapping(path="/milog/index/fastaccess")
    public Result<Void> fastAccess() {
        return null;
    }

    @RequestMapping(path="/milog/app/type/tail/storeId", method="get")
    public Result<List<AppTypeTailDTO>> queryAppTailByStoreId(@RequestParam(value="storeId") Long storeId) {
        return this.logTailService.queryAppTailByStoreId(storeId);
    }

    @RequestMapping(path="/milog/logstore/region/nameEn", method="get")
    public Result<List<MilogLogStoreDO>> queryLogStoreByRegionEn(@RequestParam(value="nameEn") String nameEn) {
        return this.logTailService.queryLogStoreByRegionEn(nameEn);
    }

    @RequestMapping(path="/milog/logtail/parse/test")
    public Result<Object> parseScriptTest(@RequestParam(value="param") MlogParseParam mlogParseParam) {
        return this.logTailService.parseScriptTest(mlogParseParam);
    }

    @RequestMapping(path="/milog/logtail/parse/example")
    public Result<Object> parseExample(@RequestParam(value="param") MlogParseParam mlogParseParam) {
        return this.logTailService.parseExample(mlogParseParam);
    }

    @RequestMapping(path="/milog/logtail/tail/quick/app", method="get")
    public Result<List<QuickQueryVO>> quickQueryByApp(@RequestParam(value="milogAppId") Long milogAppId) {
        return this.logTailService.quickQueryByApp(milogAppId);
    }

    @RequestMapping(path="/milog/store/app", method="get")
    public Result<QuickQueryVO> queryAppStore(@RequestParam(value="appId") Long appId, @RequestParam(value="platFormCode") Integer platFormCode) {
        return this.logTailService.queryAppStore(appId, platFormCode);
    }

    @RequestMapping(path="/milog/store/es/index", method="get")
    public Result<List<MenuDTO<Long, String>>> queryDeptExIndexList(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="logTypeCode") Integer logTypeCode) {
        return this.logStoreService.queryDeptExIndexList(regionCode, logTypeCode);
    }

    @RequestMapping(path="/log/store/config/redistribute", method="get")
    public Result<String> redistributeStoreConfig(@RequestParam(value="storeId") Long storeId) {
        return this.logStoreService.redistributeStoreConfig(storeId);
    }
}

