/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import cn.hutool.core.bean.BeanUtil;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.manager.domain.ClusterIndexVO;
import org.apache.ozhera.log.manager.model.bo.MilogLogstoreBo;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;

@Service
public class MilogLogstoreDao {
    @Resource
    private NutDao dao;

    public boolean newMilogLogStore(MilogLogStoreDO ml) {
        MilogLogStoreDO ret = (MilogLogStoreDO)this.dao.insert((Object)ml);
        return ret != null;
    }

    public MilogLogStoreDO insert(MilogLogStoreDO logStoreDO) {
        return (MilogLogStoreDO)this.dao.insert((Object)logStoreDO);
    }

    public boolean updateMilogLogStore(Long id, Long spaceId, String logstoreName, Integer storePeriod, Integer shardCnd, String keyList, Integer logType, String machineRoom, String updater) {
        Long utime = System.currentTimeMillis();
        int ret = this.dao.update(MilogLogStoreDO.class, Chain.make((String)"space_id", (Object)spaceId).add("logstoreName", (Object)logstoreName).add("store_period", (Object)storePeriod).add("shard_cnt", (Object)shardCnd).add("key_list", (Object)keyList).add("machine_room", (Object)machineRoom).add("updater", (Object)updater).add("log_type", (Object)logType).add("utime", (Object)utime), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public boolean updateMilogLogStore(MilogLogStoreDO ml) {
        return 1 == this.dao.update((Object)ml);
    }

    public boolean deleteMilogSpace(Long id) {
        int ret = this.dao.clear(MilogLogStoreDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public List<MilogLogStoreDO> getMilogLogstore(List<Long> ids) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"id", (String)"in", ids));
    }

    public List<MilogLogStoreDO> getMilogLogstoreBySpaceId(Long spaceId) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"space_id", (String)"=", (Object)spaceId).orderBy("ctime", "desc"));
    }

    public List<MilogLogStoreDO> getMilogLogstoreBySpaceId(List<Long> spaceIdList) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"space_id", (String)"in", spaceIdList).orderBy("ctime", "desc"));
    }

    public List<MilogLogStoreDO> getMilogLogstoreBySpaceIdRegion(Long spaceId, String region) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"space_id", (String)"=", (Object)spaceId).and("machine_room", "=", (Object)region));
    }

    public Map<String, Object> getMilogLogstoreByPage(String logsotreName, Long spaceId, int page, int pagesize) {
        Cnd cnd = Cnd.where((String)"space_id", (String)"=", (Object)spaceId);
        if (StringUtils.isNotEmpty((CharSequence)logsotreName)) {
            cnd = cnd.and("logstoreName", "like", (Object)("%" + logsotreName + "%"));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List ret = this.dao.query(MilogLogStoreDO.class, (Condition)cnd.orderBy("utime", "desc"), new Pager(page, pagesize));
        if (CollectionUtils.isNotEmpty((Collection)ret)) {
            List logstoreBos = ret.stream().map(milogLogstoreDO -> {
                MilogLogstoreBo milogLogstoreBo = new MilogLogstoreBo();
                BeanUtil.copyProperties((Object)milogLogstoreDO, (Object)milogLogstoreBo, (String[])new String[0]);
                milogLogstoreBo.setLogTypeText(LogTypeEnum.queryNameByType((Integer)milogLogstoreDO.getLogType()));
                return milogLogstoreBo;
            }).collect(Collectors.toList());
            result.put("list", logstoreBos);
        }
        result.put("total", this.dao.count(MilogLogStoreDO.class, (Condition)cnd));
        result.put("page", page);
        result.put("pageSize", pagesize);
        return result;
    }

    public Map<String, Object> getAllMilogLogstore(String source) {
        List ret = this.dao.query(MilogLogStoreDO.class, null);
        ret = ret.stream().filter(milogLogstoreDO -> {
            MilogSpaceDO milogSpace = (MilogSpaceDO)this.dao.fetch(MilogSpaceDO.class, milogLogstoreDO.getSpaceId().longValue());
            return milogSpace.getSource().equals(source);
        }).collect(Collectors.toList());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("list", ret);
        return result;
    }

    public List<MilogLogStoreDO> getAllMilogLogstore() {
        return this.dao.query(MilogLogStoreDO.class, null);
    }

    public MilogLogStoreDO getByName(String logstoreName) {
        List queryByName = this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"logstoreName", (String)"=", (Object)logstoreName));
        return queryByName == null || queryByName.isEmpty() ? null : (MilogLogStoreDO)queryByName.get(0);
    }

    public MilogLogStoreDO queryById(Long id) {
        return (MilogLogStoreDO)this.dao.fetch(MilogLogStoreDO.class, id.longValue());
    }

    public String getAppIndex(Long appId, String ip) {
        String sqlStr = "SELECT s.es_index FROM milog_logstore s, milog_logstail t WHERE t.store_id = s.id and t.app_id = @appId AND JSON_CONTAINS(t.ips, '\"" + ip + "\"')";
        Sql sql = Sqls.create((String)sqlStr);
        sql.params().set("appId", (Object)appId);
        sql.setCallback(Sqls.callback.str());
        this.dao.execute(sql);
        return sql.getString();
    }

    public boolean verifyExistByName(String logstoreName, Long id, Long spaceId) {
        int count;
        Cnd cnd = Cnd.where((String)"logstoreName", (String)"=", (Object)logstoreName);
        if (null != id) {
            cnd.andNot("id", "=", (Object)id);
        }
        if (null != spaceId) {
            cnd.and("space_id", "=", (Object)spaceId);
        }
        return (count = this.dao.count(MilogLogStoreDO.class, (Condition)cnd)) > 0;
    }

    public List<MilogLogStoreDO> queryStoreBySpaceStoreNameVague(Long spaceId, String storeNamePrefix, String machineRoom) {
        Cnd cnd = Cnd.where((String)"machine_room", (String)"=", (Object)machineRoom);
        cnd.and("space_id", "=", (Object)spaceId);
        if (StringUtils.isNotBlank((CharSequence)storeNamePrefix)) {
            cnd.and("logstoreName", "like", (Object)String.format("%s%s", storeNamePrefix.trim(), "%"));
        }
        cnd.orderBy("ctime", "desc");
        return this.dao.query(MilogLogStoreDO.class, (Condition)cnd);
    }

    public MilogLogStoreDO queryStoreBySpaceStoreName(Long spaceId, String storeName, String machineRoom) {
        List logStoreDOS;
        Cnd cnd = Cnd.where((String)"machine_room", (String)"=", (Object)machineRoom);
        cnd.and("space_id", "=", (Object)spaceId);
        if (StringUtils.isNotBlank((CharSequence)storeName)) {
            cnd.and("logstoreName", "=", (Object)storeName);
        }
        if (CollectionUtils.isNotEmpty((Collection)(logStoreDOS = this.dao.query(MilogLogStoreDO.class, (Condition)cnd)))) {
            return (MilogLogStoreDO)logStoreDOS.get(logStoreDOS.size() - 1);
        }
        return null;
    }

    public List<MilogLogStoreDO> queryByIds(List<Long> storeIds) {
        Cnd cnd = Cnd.where((String)"id", (String)"in", storeIds);
        return this.dao.query(MilogLogStoreDO.class, (Condition)cnd);
    }

    public List<MilogLogStoreDO> queryAll() {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.NEW());
    }

    public List<MilogLogStoreDO> queryByEsInfo(String regionEn, Long esClusterId) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"machine_room", (String)"=", (Object)regionEn).and("es_cluster_id", "=", (Object)esClusterId));
    }

    public List<MilogLogStoreDO> queryByLogType(Integer type) {
        return this.dao.query(MilogLogStoreDO.class, (Condition)Cnd.where((String)"log_type", (String)"=", (Object)type));
    }

    public void deleteById(Long id) {
        this.dao.delete(MilogLogStoreDO.class, id.longValue());
    }

    public List<MilogLogStoreDO> queryBySpaceIdNamed(Long spaceId, String logStoreName) {
        Cnd cnd = Cnd.where((String)"space_id", (String)"=", (Object)spaceId);
        cnd.and("logstoreName", "=", (Object)logStoreName);
        return this.dao.query(MilogLogStoreDO.class, (Condition)cnd);
    }

    public List<ClusterIndexVO> queryClusterIndexByAppId(Long appId) {
        Sql sql = Sqls.queryEntity((String)"SELECT DISTINCT se.es_cluster_id as clusterId, se.es_index as indexName FROM milog_logstail sl LEFT JOIN milog_logstore se ON sl.store_id = se.id WHERE sl.app_id = @appId;");
        sql.params().set("appId", (Object)appId);
        sql.setEntity(this.dao.getEntity(ClusterIndexVO.class));
        this.dao.execute(sql);
        return sql.getList(ClusterIndexVO.class);
    }
}

