/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.tail;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.app.api.model.HeraSimpleEnv;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.model.bo.LogTailParam;
import org.apache.ozhera.log.manager.model.dto.MilogAppEnvDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.extension.agent.MilogAgentServiceImpl;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.impl.HeraAppEnvServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogAppMiddlewareRelServiceImpl;
import org.apache.ozhera.log.manager.service.nacos.FetchStreamMachineService;
import org.apache.ozhera.log.manager.service.nacos.impl.StreamConfigNacosPublisher;
import org.apache.ozhera.log.model.LogtailConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultTailExtensionService")
public class DefaultTailExtensionService
implements TailExtensionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTailExtensionService.class);
    @Resource
    private LogTailServiceImpl logTailService;
    @Resource
    private MilogAppMiddlewareRelServiceImpl milogAppMiddlewareRelService;
    @Resource
    private HeraAppEnvServiceImpl heraAppEnvService;
    @Resource(name="defaultAgentExtensionService")
    private MilogAgentServiceImpl milogAgentService;
    @Resource
    private MilogLogTailDao milogLogtailDao;

    @Override
    public boolean tailHandlePreprocessingSwitch(MilogLogStoreDO milogLogStore, LogTailParam param) {
        return true;
    }

    @Override
    public boolean bindMqResourceSwitch(MilogLogStoreDO logStore, Integer appType) {
        return Objects.equals((int)ProjectTypeEnum.MIONE_TYPE.getCode(), appType);
    }

    @Override
    public boolean bindPostProcessSwitch(Long storeId) {
        return false;
    }

    @Override
    public void postProcessing() {
    }

    @Override
    public void defaultBindingAppTailConfigRel(Long id, Long milogAppId, Long middleWareId, String topicName, Integer batchSendSize) {
        this.milogAppMiddlewareRelService.defaultBindingAppTailConfigRel(id, milogAppId, middleWareId, topicName, batchSendSize);
    }

    @Override
    public void defaultBindingAppTailConfigRelPostProcess(Long spaceId, Long storeId, Long tailId, Long milogAppId, Long storeMqResourceId) {
    }

    @Override
    public void sendMessageOnCreate(LogTailParam param, MilogLogTailDo mt, Long milogAppId, boolean supportedConsume) {
        if (param.getCollectionReady().booleanValue()) {
            CompletableFuture.runAsync(() -> this.logTailService.sengMessageToAgent(milogAppId, mt));
        }
        if (supportedConsume) {
            this.logTailService.sengMessageToStream(mt, OperateEnum.ADD_OPERATE.getCode());
        }
    }

    @Override
    public void updateSendMsg(MilogLogTailDo milogLogtailDo, List<String> oldIps, boolean supportedConsume) {
        if (milogLogtailDo.getCollectionReady().booleanValue()) {
            CompletableFuture.runAsync(() -> this.milogAgentService.publishIncrementConfig(milogLogtailDo.getId(), milogLogtailDo.getMilogAppId(), milogLogtailDo.getIps()));
        }
        if (supportedConsume) {
            this.logTailService.sengMessageToStream(milogLogtailDo, OperateEnum.UPDATE_OPERATE.getCode());
        }
        this.logTailService.compareChangeDelIps(milogLogtailDo.getId(), milogLogtailDo.getLogPath(), milogLogtailDo.getIps(), oldIps);
    }

    @Override
    public void logTailDoExtraFiled(MilogLogTailDo milogLogtailDo, MilogLogStoreDO logStoreDO, LogTailParam logTailParam) {
        milogLogtailDo.setIps(logTailParam.getIps());
    }

    @Override
    public void logTailConfigExtraField(LogtailConfig logtailConfig, MilogMiddlewareConfig middlewareConfig) {
    }

    @Override
    public void logTailDelPostProcess(MilogLogStoreDO logStoreDO, MilogLogTailDo milogLogtailDo) {
    }

    @Override
    public List<MilogAppEnvDTO> getEnInfosByAppId(AppBaseInfo appBaseInfo, Long milogAppId, Integer deployWay, String machineRoom) {
        List<HeraSimpleEnv> heraSimpleEnvs = null;
        try {
            heraSimpleEnvs = this.heraAppEnvService.querySimpleEnvAppBaseInfoId(milogAppId.intValue());
        }
        catch (Exception e) {
            log.error(String.format("query ip error:milogAppId:%s,deployWay:%s", milogAppId, deployWay), (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty(heraSimpleEnvs)) {
            return heraSimpleEnvs.stream().map(envBo -> MilogAppEnvDTO.builder().label(envBo.getName()).value(envBo.getId()).ips(envBo.getIps()).build()).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean decorateTailDTOValId(Integer logType, Integer appType) {
        return true;
    }

    @Override
    public List<String> getStreamMachineUniqueList(Integer projectTypeCode, String motorRoomEn) {
        return Lists.newArrayList();
    }

    @Override
    public String deleteCheckProcessPre(Long id) {
        return "";
    }

    @Override
    public String validLogPath(LogTailParam param) {
        if (Objects.equals(ProjectTypeEnum.MIONE_TYPE.getCode(), param.getAppType())) {
            List<MilogLogTailDo> appLogTails = this.milogLogtailDao.queryByMilogAppAndEnv(param.getMilogAppId(), param.getEnvId());
            for (int i = 0; i < appLogTails.size() && null == param.getId(); ++i) {
                if (!appLogTails.get(i).getLogPath().equals(param.getLogPath())) continue;
                return "The current deployment environment for the file " + param.getLogPath() + " Log collection is configured with the following aliases:" + appLogTails.get(i).getTail();
            }
        }
        return "";
    }

    @Override
    public void publishStreamConfigPostProcess(StreamConfigNacosPublisher streamConfigNacosPublisher, Long spaceId, String motorRoomEn) {
    }

    @Override
    public List<String> fetchStreamUniqueKeyList(FetchStreamMachineService fetchStreamMachineService, Long spaceId, String motorRoomEn) {
        List<String> mioneStreamIpList = fetchStreamMachineService.streamMachineUnique();
        if (CollectionUtils.isEmpty(mioneStreamIpList)) {
            mioneStreamIpList = this.getStreamMachineUniqueList(null, motorRoomEn);
        }
        return mioneStreamIpList;
    }
}

