/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.vo.TailLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.api.service.LogProcessService;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.domain.LogProcess;
import org.apache.ozhera.log.manager.mapper.MilogLogProcessMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogLogProcessDOMybatis;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogProcessServiceImpl
implements LogProcessService {
    private static final Logger log = LoggerFactory.getLogger(LogProcessServiceImpl.class);
    @Resource
    private MilogLogProcessMapper processMapper;
    @Resource
    private LogProcess logProcess;
    @Resource
    private MilogLogTailDao logtailDao;

    public void updateLogProcess(UpdateLogProcessCmd cmd) {
        if (null != this.logProcess) {
            this.logProcess.updateLogProcess(cmd);
        }
    }

    public MilogLogProcessDOMybatis getByIdFramework(Long id) {
        return (MilogLogProcessDOMybatis)this.processMapper.selectById(id);
    }

    public Result<List<TailLogProcessDTO>> getStoreLogProcess(String type, String value) {
        List<TailLogProcessDTO> dtoList;
        if (StringUtils.isEmpty((CharSequence)type) || StringUtils.isEmpty((CharSequence)value)) {
            return Result.failParam((String)"Type and value cannot be empty");
        }
        switch (type) {
            case "store": {
                dtoList = this.logProcess.getStoreLogProcess(Long.parseLong(value), "");
                break;
            }
            case "tail": {
                dtoList = this.logProcess.getTailLogProcess(Long.parseLong(value), "");
                break;
            }
            case "ip": {
                String[] params = value.split(",");
                dtoList = this.logProcess.getStoreLogProcess(Long.parseLong(params[0]), params[1]);
                break;
            }
            case "tail&ip": {
                String[] params2 = value.split(",");
                dtoList = this.logProcess.getTailLogProcess(Long.parseLong(params2[0]), params2[1]);
                break;
            }
            default: {
                return Result.failParam((String)"The type type is not legal");
            }
        }
        return Result.success(dtoList);
    }

    public Result<List<UpdateLogProcessCmd.CollectDetail>> getColProcessImperfect(Double progressRation) {
        if (null == progressRation) {
            return Result.failParam((String)"The parameter cannot be empty");
        }
        return Result.success(this.upColProcessTailName(this.logProcess.getColProcessImperfect(progressRation)));
    }

    @Nullable
    private List<UpdateLogProcessCmd.CollectDetail> upColProcessTailName(List<UpdateLogProcessCmd.CollectDetail> colProcessImperfect) {
        HashMap tailIdToDetailMap = new HashMap();
        colProcessImperfect.parallelStream().forEach(collectDetail -> {
            String tailId = collectDetail.getTailId();
            if (StringUtils.isNotBlank((CharSequence)tailId)) {
                try {
                    MilogLogTailDo logTailDo = this.logtailDao.queryById(Long.valueOf(tailId));
                    if (logTailDo != null) {
                        collectDetail.setTailName(logTailDo.getTail());
                    }
                    tailIdToDetailMap.merge(tailId, collectDetail, (existingDetail, newDetail) -> {
                        existingDetail.getIpList().addAll(newDetail.getIpList());
                        existingDetail.getIpList().stream().distinct().collect(Collectors.toList());
                        existingDetail.getFileProgressDetails().addAll(newDetail.getFileProgressDetails());
                        return existingDetail;
                    });
                }
                catch (Exception e) {
                    log.error("process data error", (Throwable)e);
                }
            }
        });
        return new ArrayList<UpdateLogProcessCmd.CollectDetail>(tailIdToDetailMap.values());
    }
}

