/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.xiaomi.mone.tpc.common.enums.NodeUserRelTypeEnum;
import com.xiaomi.mone.tpc.common.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.common.vo.NodeVo;
import com.xiaomi.mone.tpc.common.vo.PageDataVo;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.db.Transactional;
import com.xiaomi.youpin.infra.rpc.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ozhera.log.api.enums.LogStructureEnum;
import org.apache.ozhera.log.api.enums.MachineRegionEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ProjectSourceEnum;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.domain.Tpc;
import org.apache.ozhera.log.manager.model.MilogSpaceParam;
import org.apache.ozhera.log.manager.model.convert.MilogSpaceConvert;
import org.apache.ozhera.log.manager.model.dto.MapDTO;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceDTO;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.service.BaseService;
import org.apache.ozhera.log.manager.service.LogSpaceService;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.ozhera.log.manager.service.impl.TpcSpaceAuthService;
import org.apache.ozhera.log.manager.user.MoneUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogSpaceServiceImpl
extends BaseService
implements LogSpaceService {
    private static final Logger log = LoggerFactory.getLogger(LogSpaceServiceImpl.class);
    @Resource
    private MilogSpaceDao milogSpaceDao;
    @Resource
    private MilogLogstoreDao milogLogstoreDao;
    @Resource
    private TpcSpaceAuthService spaceAuthService;
    @Resource
    private LogTailServiceImpl logTailService;
    @Resource
    private Tpc tpc;
    private static final Cache<String, List<MapDTO<String, Long>>> SPACE_ALL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build();

    @Override
    public org.apache.ozhera.log.common.Result<String> newMilogSpace(MilogSpaceParam param) {
        if (Objects.isNull(param) || StringUtils.isBlank((String)param.getSpaceName())) {
            return org.apache.ozhera.log.common.Result.failParam((String)"Parameter error");
        }
        String spaceName = param.getSpaceName();
        if (this.milogSpaceDao.verifyExistByName(spaceName)) {
            return org.apache.ozhera.log.common.Result.failParam((String)"There is a space name of the same name");
        }
        MilogSpaceDO milogSpaceDO = this.wrapMilogSpaceDO(param);
        this.wrapBaseCommon(milogSpaceDO, OperateEnum.ADD_OPERATE);
        MilogSpaceDO dbDO = this.milogSpaceDao.newMilogSpace(milogSpaceDO);
        if (Objects.isNull(dbDO.getId())) {
            return org.apache.ozhera.log.common.Result.failParam((String)"Space is not saved successfully, please try again");
        }
        String creator = MoneUserContext.getCurrentUser().getUser();
        List otherAdmins = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(param.getAdmins())) {
            creator = param.getAdmins().get(0);
            if (param.getAdmins().size() > 1) {
                otherAdmins = CollectionUtil.sub(param.getAdmins(), (int)1, (int)param.getAdmins().size());
            }
        }
        Result tpcResult = this.spaceAuthService.saveSpacePerm(dbDO, creator);
        this.addMemberAsync(dbDO.getId(), otherAdmins);
        SPACE_ALL_CACHE.invalidate((Object)LogSpaceServiceImpl.buildCacheKey(param.getTenantId()));
        if (tpcResult == null || tpcResult.getCode() != 0) {
            this.milogSpaceDao.deleteMilogSpace(dbDO.getId());
            log.error("The new space is not associated with a permission system,space:[{}], tpcResult:[{}]", (Object)dbDO, (Object)tpcResult);
            return org.apache.ozhera.log.common.Result.failParam((String)"Space is not associated with a permission system");
        }
        return org.apache.ozhera.log.common.Result.success();
    }

    private void addMemberAsync(Long spaceId, List<String> otherAdmins) {
        if (CollectionUtil.isNotEmpty(otherAdmins)) {
            List<CompletableFuture> adminAsyncResult = otherAdmins.stream().map(admin -> CompletableFuture.runAsync(() -> this.spaceAuthService.addSpaceMember(spaceId, (String)admin, UserTypeEnum.CAS_TYPE.getCode(), NodeUserRelTypeEnum.MANAGER.getCode()))).toList();
            CompletableFuture.allOf(adminAsyncResult.toArray(new CompletableFuture[0])).join();
        }
    }

    private MilogSpaceDO wrapMilogSpaceDO(MilogSpaceParam param) {
        MilogSpaceDO milogSpaceDO = new MilogSpaceDO();
        milogSpaceDO.setSpaceName(param.getSpaceName());
        milogSpaceDO.setDescription(param.getDescription());
        return milogSpaceDO;
    }

    @Override
    public org.apache.ozhera.log.common.Result<MilogSpaceDTO> getMilogSpaceById(Long id) {
        if (null == id) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "ID cannot be empty");
        }
        MilogSpaceDO milogSpace = this.milogSpaceDao.getMilogSpaceById(id);
        if (null != milogSpace) {
            MilogSpaceDTO milogSpaceDTO = new MilogSpaceDTO();
            milogSpaceDTO.setCreator(milogSpace.getCreator());
            milogSpaceDTO.setCtime(milogSpace.getCtime());
            milogSpaceDTO.setDescription(milogSpace.getDescription());
            milogSpaceDTO.setId(milogSpace.getId());
            milogSpaceDTO.setTenantId(milogSpace.getTenantId());
            milogSpaceDTO.setTenantName("todo");
            milogSpaceDTO.setUtime(milogSpace.getUtime());
            milogSpaceDTO.setSpaceName(milogSpace.getSpaceName());
            return new org.apache.ozhera.log.common.Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), (Object)milogSpaceDTO);
        }
        return new org.apache.ozhera.log.common.Result(CommonError.NOT_EXISTS_DATA.getCode(), CommonError.NOT_EXISTS_DATA.getMessage());
    }

    @Override
    public org.apache.ozhera.log.common.Result<PageInfo<MilogSpaceDTO>> getMilogSpaceByPage(String spaceName, Long tenantId, Integer page, Integer pageSize) {
        Result<PageDataVo<NodeVo>> userPermSpacePage = this.spaceAuthService.getUserPermSpace(spaceName, page, pageSize);
        PageInfo<MilogSpaceDTO> spaceDTOPageInfo = MilogSpaceConvert.INSTANCE.fromTpcPage((PageDataVo<NodeVo>)((PageDataVo)userPermSpacePage.getData()));
        return org.apache.ozhera.log.common.Result.success(spaceDTOPageInfo);
    }

    @Override
    public org.apache.ozhera.log.common.Result<List<MapDTO<String, Long>>> getMilogSpaces(Long tenantId) {
        int pageNum = 1;
        int defaultPageSize = 300;
        String defaultSpaceKey = LogSpaceServiceImpl.buildCacheKey(tenantId);
        List cachedResult = (List)SPACE_ALL_CACHE.getIfPresent((Object)defaultSpaceKey);
        if (CollectionUtils.isNotEmpty((Collection)cachedResult)) {
            return org.apache.ozhera.log.common.Result.success((Object)cachedResult);
        }
        List<NodeVo> nodeVos = this.fetchAllNodeVos(pageNum, defaultPageSize);
        List result = nodeVos.parallelStream().map(nodeVo -> new MapDTO<String, Long>(nodeVo.getNodeName(), nodeVo.getOutId())).collect(Collectors.toList());
        SPACE_ALL_CACHE.put((Object)defaultSpaceKey, result);
        return org.apache.ozhera.log.common.Result.success(result);
    }

    private static String buildCacheKey(Long tenantId) {
        MoneUser currentUser = MoneUserContext.getCurrentUser();
        return String.format("%s-%s", tenantId == null ? "local-key" : tenantId.toString(), currentUser.getUser());
    }

    private List<NodeVo> fetchAllNodeVos(int pageNum, int pageSize) {
        ArrayList<NodeVo> nodeVos = new ArrayList<NodeVo>();
        while (true) {
            Result<PageDataVo<NodeVo>> response;
            if ((response = this.spaceAuthService.getUserPermSpace("", pageNum, pageSize)).getCode() != 0) {
                throw new MilogManageException("query space from tpc error");
            }
            PageDataVo pageData = (PageDataVo)response.getData();
            if (pageData == null || CollectionUtils.isEmpty((Collection)pageData.getList())) break;
            nodeVos.addAll(pageData.getList());
            if (pageData.getList().size() < pageSize) break;
            ++pageNum;
        }
        return nodeVos;
    }

    @Override
    @Transactional
    public org.apache.ozhera.log.common.Result<String> updateMilogSpace(MilogSpaceParam param) {
        if (null == param || StringUtils.isBlank((String)param.getSpaceName())) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "Parameter error", (Object)"");
        }
        if (this.milogSpaceDao.verifyExistByName(param.getSpaceName(), param.getId())) {
            return new org.apache.ozhera.log.common.Result(CommonError.UnknownError.getCode(), "There is a space name of the same name", (Object)"");
        }
        MilogSpaceDO milogSpace = this.milogSpaceDao.queryById(param.getId());
        if (null == milogSpace) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "logSpace does not exist", (Object)"");
        }
        if (Objects.equals(param.getSpaceName(), milogSpace.getSpaceName()) && Objects.equals(param.getDescription(), milogSpace.getDescription())) {
            return org.apache.ozhera.log.common.Result.success((Object)"the logSpace data has not changed");
        }
        if (!this.tpc.hasPerm(MoneUserContext.getCurrentUser(), param.getId())) {
            return org.apache.ozhera.log.common.Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        this.wrapMilogSpace(milogSpace, param);
        this.wrapBaseCommon(milogSpace, OperateEnum.UPDATE_OPERATE);
        if (this.milogSpaceDao.update(milogSpace)) {
            Result tpcResult = this.spaceAuthService.updateSpaceTpc(param, MoneUserContext.getCurrentUser().getUser());
            SPACE_ALL_CACHE.invalidate((Object)LogSpaceServiceImpl.buildCacheKey(param.getTenantId()));
            if (tpcResult == null || tpcResult.getCode() != 0) {
                log.error("Modify the space permission system not associated with it,space:[{}], tpcResult:[{}]", (Object)milogSpace, (Object)tpcResult);
                return org.apache.ozhera.log.common.Result.success((Object)"To modify the unassociated permission system of space, contact the server-side performance group");
            }
            return org.apache.ozhera.log.common.Result.success();
        }
        log.warn("[MilogSpaceService.updateMilogSpace] update MilogSpace err,spaceName:{},spaceId:{}", (Object)param.getSpaceName(), (Object)param.getId());
        return new org.apache.ozhera.log.common.Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage(), (Object)"");
    }

    @Override
    @Transactional
    public org.apache.ozhera.log.common.Result<String> deleteMilogSpace(Long id) {
        if (null == id) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "ID cannot be empty", (Object)"");
        }
        if (!this.tpc.hasPerm(MoneUserContext.getCurrentUser(), id)) {
            return org.apache.ozhera.log.common.Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        MilogSpaceDO milogSpace = this.milogSpaceDao.getMilogSpaceById(id);
        if (null == milogSpace) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "logSpace does not exist", (Object)"");
        }
        List<MilogLogStoreDO> stores = this.milogLogstoreDao.getMilogLogstoreBySpaceId(id);
        if (stores != null && stores.size() != 0) {
            return new org.apache.ozhera.log.common.Result(CommonError.ParamsError.getCode(), "There is a store under this space and cannot be deleted", (Object)"");
        }
        if (this.milogSpaceDao.deleteMilogSpace(id)) {
            this.logTailService.deleteConfigRemote(id, id, MachineRegionEnum.CN_MACHINE.getEn(), LogStructureEnum.SPACE);
            SPACE_ALL_CACHE.invalidate((Object)LogSpaceServiceImpl.buildCacheKey(milogSpace.getTenantId()));
            Result tpcResult = this.spaceAuthService.deleteSpaceTpc(id, MoneUserContext.getCurrentUser().getUser(), MoneUserContext.getCurrentUser().getUserType());
            if (tpcResult == null || tpcResult.getCode() != 0) {
                log.error("Remove the space without associated permission system,space:[{}], tpcResult:[{}]", (Object)milogSpace, (Object)tpcResult);
                return org.apache.ozhera.log.common.Result.failParam((String)"To delete a space system that is not associated with it, contact the server performance group");
            }
            return org.apache.ozhera.log.common.Result.success();
        }
        log.warn("[MilogSpaceService.deleteMilogSpace] delete MilogSpace err,spaceId:{}", (Object)id);
        return org.apache.ozhera.log.common.Result.failParam((String)"Space deletion failed, please try again");
    }

    @Override
    public org.apache.ozhera.log.common.Result<String> setSpacePermission(Long spaceId, String permDeptIds) {
        if (spaceId == null || StringUtils.isEmpty((String)permDeptIds)) {
            return org.apache.ozhera.log.common.Result.fail((CommonError)CommonError.ParamsError);
        }
        MilogSpaceDO space = this.milogSpaceDao.getMilogSpaceById(spaceId);
        if (!permDeptIds.contains(space.getCreateDeptId())) {
            return org.apache.ozhera.log.common.Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"The Create Department permission cannot be revoked");
        }
        space.setPermDeptId(permDeptIds);
        boolean update = this.milogSpaceDao.update(space);
        return update ? org.apache.ozhera.log.common.Result.success() : org.apache.ozhera.log.common.Result.fail((CommonError)CommonError.UnknownError);
    }

    @Override
    public MilogSpaceDO buildMiLogSpace(MilogSpaceParam cmd, String appCreator) {
        MilogSpaceDO ms = new MilogSpaceDO();
        this.wrapMilogSpace(ms, cmd, ProjectSourceEnum.ONE_SOURCE.getSource());
        this.wrapBaseCommon(ms, OperateEnum.ADD_OPERATE, appCreator);
        return ms;
    }
}

