/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.enums.MQSourceEnum;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ResourceEnum;
import org.apache.ozhera.log.api.model.bo.MiLogResource;
import org.apache.ozhera.log.api.model.bo.ResourcePage;
import org.apache.ozhera.log.api.model.vo.EsIndexVo;
import org.apache.ozhera.log.api.model.vo.ResourceInfo;
import org.apache.ozhera.log.api.model.vo.ResourceUserSimple;
import org.apache.ozhera.log.api.model.vo.ValueKeyObj;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.bootstrap.LogStoragePlugin;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.common.validation.ResourceValidation;
import org.apache.ozhera.log.manager.dao.MilogAppMiddlewareRelDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogMiddlewareConfigDao;
import org.apache.ozhera.log.manager.domain.LogTail;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.mapper.MilogEsIndexMapper;
import org.apache.ozhera.log.manager.model.bo.MiddlewareAddParam;
import org.apache.ozhera.log.manager.model.bo.MiddlewareQueryParam;
import org.apache.ozhera.log.manager.model.bo.MiddlewareUpdateParam;
import org.apache.ozhera.log.manager.model.dto.MiddlewareConfigDTO;
import org.apache.ozhera.log.manager.model.page.PageInfo;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsIndexDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.BaseService;
import org.apache.ozhera.log.manager.service.MilogMiddlewareConfigService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.jetbrains.annotations.NotNull;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.util.cri.IsNull;
import org.nutz.dao.util.cri.SqlExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogMiddlewareConfigServiceImpl
extends BaseService
implements MilogMiddlewareConfigService {
    private static final Logger log = LoggerFactory.getLogger(MilogMiddlewareConfigServiceImpl.class);
    @Resource
    private MilogMiddlewareConfigDao milogMiddlewareConfigDao;
    @Resource
    private MilogAppMiddlewareRelDao milogAppMiddlewareRelDao;
    @Resource
    private ResourceValidation resourceValidation;
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;
    @Resource
    private MilogEsIndexMapper milogEsIndexMapper;
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private LogStoragePlugin esPlugin;
    @Resource
    private LogTail logTail;
    private ResourceExtensionService resourceExtensionService;
    private List<Integer> accurateTypes = Arrays.stream(MQSourceEnum.values()).map(MQSourceEnum::getCode).toList();

    public void init() {
        this.resourceExtensionService = ResourceExtensionServiceFactory.getResourceExtensionService();
    }

    @Override
    public PageInfo<MilogMiddlewareConfig> queryMiddlewareConfigPage(MiddlewareQueryParam middlewareQueryParam) {
        Condition cnd = this.handleParamToCondition(middlewareQueryParam);
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryMiddlewareConfigByCondition(cnd, new Pager(middlewareQueryParam.getPage().intValue(), middlewareQueryParam.getPageSize().intValue()));
        Integer count = this.milogMiddlewareConfigDao.queryMiddlewareConfigCountByCondition(cnd);
        return new PageInfo<MilogMiddlewareConfig>(middlewareQueryParam.getPage(), middlewareQueryParam.getPageSize(), count, milogMiddlewareConfigs);
    }

    @Override
    public Result addMiddlewareConfig(MiddlewareAddParam middlewareAddParam) {
        MilogMiddlewareConfig config;
        List<String> checkMsg = this.preCheckMiddlewareConfig(middlewareAddParam);
        if (CollectionUtils.isNotEmpty(checkMsg)) {
            return Result.failParam((String)checkMsg.stream().collect(Collectors.joining(",")));
        }
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryMiddlewareConfigByCondition((Condition)Cnd.where((String)"alias", (String)"=", (Object)middlewareAddParam.getAlias()), null);
        if (CollectionUtils.isNotEmpty(milogMiddlewareConfigs)) {
            return Result.failParam((String)"The alias already exists, please modify it and save it");
        }
        if (this.accurateTypes.contains(middlewareAddParam.getType()) && null != (config = this.milogMiddlewareConfigDao.queryDefaultMiddlewareConfig()) && middlewareAddParam.getIsDefault() == 1) {
            return Result.failParam((String)"There will only be one default value, please turn off the other default defaults");
        }
        this.milogMiddlewareConfigDao.addMiddlewareConfig(this.AddParamToAddEntity(middlewareAddParam));
        return Result.success();
    }

    @Override
    public Result updateMiddlewareConfig(MiddlewareUpdateParam middlewareUpdateParam) {
        MilogMiddlewareConfig config2;
        List middlewareConfigs;
        List<String> checkMsg = this.preCheckUpdateMiddlewareConfig(middlewareUpdateParam);
        if (CollectionUtils.isNotEmpty(checkMsg)) {
            return Result.failParam((String)checkMsg.stream().collect(Collectors.joining(",")));
        }
        MilogMiddlewareConfig milogMiddlewareConfig = this.milogMiddlewareConfigDao.queryById(middlewareUpdateParam.getId());
        if (null == milogMiddlewareConfig) {
            return Result.failParam((String)"The modified object does not exist, make sure the id is correct");
        }
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryMiddlewareConfigByCondition((Condition)Cnd.where((String)"alias", (String)"=", (Object)middlewareUpdateParam.getAlias()), null);
        if (CollectionUtils.isNotEmpty(milogMiddlewareConfigs) && CollectionUtils.isNotEmpty(middlewareConfigs = milogMiddlewareConfigs.stream().filter(config -> config.getId().longValue() != middlewareUpdateParam.getId().longValue()).collect(Collectors.toList()))) {
            return Result.failParam((String)"The alias already exists, please modify it and save it");
        }
        if (this.accurateTypes.contains(middlewareUpdateParam.getType()) && null != (config2 = this.milogMiddlewareConfigDao.queryDefaultMiddlewareConfig()) && middlewareUpdateParam.getIsDefault() == 1 && !config2.getId().equals(middlewareUpdateParam.getId())) {
            return Result.failParam((String)"There will only be one default value, please turn off the other default values and modify it");
        }
        this.milogMiddlewareConfigDao.updateMiddlewareConfig(this.updateParamToUpdateEntity(middlewareUpdateParam, milogMiddlewareConfig));
        return Result.success();
    }

    @Override
    public Result deleteMiddlewareConfig(Long id) {
        if (null == id) {
            return Result.failParam((String)"id can not null");
        }
        MilogMiddlewareConfig milogMiddlewareConfig = this.milogMiddlewareConfigDao.queryById(id);
        if (null == milogMiddlewareConfig) {
            return Result.failParam((String)"The deleted object does not exist, make sure the Id is correct");
        }
        List<MilogAppMiddlewareRel> milogAppMiddlewareRels = this.milogAppMiddlewareRelDao.queryByCondition(null, id, null);
        if (CollectionUtils.isNotEmpty(milogAppMiddlewareRels)) {
            return Result.failParam((String)"The associated tail exists, make sure the tail has changed");
        }
        this.milogMiddlewareConfigDao.deleteMiddlewareConfig(id);
        return Result.success();
    }

    @Override
    public List<MilogMiddlewareConfig> queryMiddlewareConfigList() {
        return this.milogMiddlewareConfigDao.queryAll();
    }

    @Override
    public Result<MilogMiddlewareConfig> queryMiddlewareConfigById(Long id) {
        if (null == id) {
            return Result.failParam((String)"id can not null");
        }
        MilogMiddlewareConfig config = this.milogMiddlewareConfigDao.queryById(id);
        MiddlewareConfigDTO middlewareConfigDTO = new MiddlewareConfigDTO();
        BeanUtil.copyProperties((Object)config, (Object)middlewareConfigDTO, (String[])new String[0]);
        middlewareConfigDTO.setTypes(Arrays.asList(config.getType(), config.getRegionEn()));
        return Result.success((Object)middlewareConfigDTO);
    }

    @Override
    public PageInfo<ResourceInfo> queryResourceWithTab(ResourcePage resourcePage) {
        if (null == resourcePage.getResourceCode()) {
            return PageInfo.emptyPageInfo();
        }
        Cnd mqCnd = this.buildMqQueryCnd(resourcePage);
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryMiddlewareConfigByCondition((Condition)mqCnd, null);
        List<MilogMiddlewareConfig> userShowAuthorityConfigs = this.resourceExtensionService.userShowAuthority(milogMiddlewareConfigs);
        List pageList = CollectionUtil.page((int)(resourcePage.getPage() - 1), (int)resourcePage.getPageSize(), userShowAuthorityConfigs);
        Integer mqResourceTotal = userShowAuthorityConfigs.size();
        Long esResourceTotal = this.queryStorageResource(pageList, resourcePage);
        List resourceInfos = pageList.stream().map(MilogMiddlewareConfig::configToResourceVO).collect(Collectors.toList());
        return new PageInfo<ResourceInfo>(resourcePage.getPage(), resourcePage.getPageSize(), mqResourceTotal + esResourceTotal.intValue(), resourceInfos);
    }

    private Cnd buildMqQueryCnd(ResourcePage resourcePage) {
        Cnd cnd = Cnd.NEW();
        if (Objects.equals(ResourceEnum.MQ.getCode(), resourcePage.getResourceCode())) {
            cnd.andEX("type", "in", this.resourceExtensionService.getMqResourceCodeList());
        }
        if (null != resourcePage.getRegionEnCode()) {
            cnd.andEX("region_en", "=", (Object)resourcePage.getRegionEnCode());
        }
        if (StringUtils.isNotBlank((CharSequence)resourcePage.getAliasName())) {
            cnd.andEX("alias", "like", (Object)String.format("%s%s%s", "%", resourcePage.getAliasName(), "%"));
        }
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), resourcePage.getResourceCode())) {
            cnd.and((SqlExpression)new IsNull("id"));
        }
        return cnd;
    }

    private Long queryStorageResource(List<MilogMiddlewareConfig> milogMiddlewareConfigs, ResourcePage resourcePage) {
        Integer count = 0;
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), resourcePage.getResourceCode())) {
            List clusterDOList = this.milogEsClusterMapper.selectList(this.generateEsQueryWrapper(resourcePage));
            List<MilogMiddlewareConfig> configEsList = clusterDOList.stream().map(MilogEsClusterDO::miLogEsResourceToConfig).toList();
            configEsList = this.resourceExtensionService.userShowAuthority(configEsList);
            List pageList = CollectionUtil.page((int)(resourcePage.getPage() - 1), (int)resourcePage.getPageSize(), configEsList);
            milogMiddlewareConfigs.addAll(pageList);
            count = configEsList.size();
        }
        return count.longValue();
    }

    private Wrapper generateEsQueryWrapper(ResourcePage resourcePage) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)resourcePage.getRegionEnCode())) {
            queryWrapper.eq((Object)"area", (Object)resourcePage.getRegionEnCode());
        }
        if (StringUtils.isNotBlank((CharSequence)resourcePage.getAliasName())) {
            queryWrapper.like((Object)"name", (Object)resourcePage.getAliasName());
        }
        this.resourceExtensionService.filterEsQueryWrapper(queryWrapper);
        return queryWrapper;
    }

    @Override
    public Result<String> resourceOperate(MiLogResource miLogResource) {
        String errInfos = this.resourceValidation.resourceOperateValid(miLogResource);
        if (StringUtils.isNotBlank((CharSequence)errInfos)) {
            return Result.failParam((String)errInfos);
        }
        OperateEnum operateEnum = OperateEnum.queryByCode((Integer)miLogResource.getOperateCode());
        this.checkAlias(miLogResource, operateEnum);
        switch (operateEnum) {
            case ADD_OPERATE: {
                this.addResource(miLogResource);
                break;
            }
            case UPDATE_OPERATE: {
                this.updateResource(miLogResource);
                break;
            }
            case DELETE_OPERATE: {
                this.deleteResource(miLogResource.getResourceCode(), miLogResource.getId());
                break;
            }
        }
        return Result.success((Object)"success");
    }

    private void checkEsAddressPortOperate(MiLogResource miLogResource) {
        String serviceUrl = miLogResource.getServiceUrl();
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return;
        }
        int index = serviceUrl.lastIndexOf(":");
        if (index == -1) {
            serviceUrl = String.format("%s:%s", serviceUrl, "80");
        } else {
            String portStr = serviceUrl.substring(index + 1);
            if (StringUtils.isBlank((CharSequence)portStr)) {
                serviceUrl = String.format("%s%s", serviceUrl, "80");
            }
        }
        miLogResource.setServiceUrl(serviceUrl);
    }

    private void deleteResource(Integer resourceCode, Long id) {
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), resourceCode)) {
            this.milogEsClusterMapper.deleteById(id);
            this.deleteEsIndex(id);
            return;
        }
        Result result = this.deleteMiddlewareConfig(id);
        if (result.getCode() != CommonError.Success.getCode()) {
            throw new MilogManageException(result.getMessage());
        }
    }

    @Override
    public String synchronousResourceLabel(Long id) {
        this.synchronousMqResourceLabel(id);
        this.synchronousEsResourceLabel(id);
        return "success";
    }

    private void synchronousMqResourceLabel(Long id) {
        List<Object> milogMiddlewareConfigs = Lists.newArrayList();
        if (null != id) {
            milogMiddlewareConfigs.add(this.milogMiddlewareConfigDao.queryById(id));
        }
        if (CollectionUtils.isEmpty((Collection)milogMiddlewareConfigs)) {
            milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryAll();
        }
        milogMiddlewareConfigs.forEach(this::updateMqResourceLabel);
    }

    private void synchronousEsResourceLabel(Long id) {
        List esClusterDOS = Lists.newArrayList();
        if (null != id) {
            esClusterDOS.add((MilogEsClusterDO)this.milogEsClusterMapper.selectById(id));
        }
        if (CollectionUtils.isEmpty((Collection)esClusterDOS)) {
            esClusterDOS = this.milogEsClusterMapper.selectList((Wrapper)new QueryWrapper());
        }
        esClusterDOS.forEach(this::updateEsResourceLabel);
    }

    @Override
    public ResourceUserSimple userResourceList(String regionCode, Integer logTypeCode) {
        if (StringUtils.isBlank((CharSequence)regionCode)) {
            throw new MilogManageException("Region Code cannot be empty");
        }
        if (null == logTypeCode) {
            throw new MilogManageException("Log Type Code cannot be empty");
        }
        ResourceUserSimple resourceUserSimple = new ResourceUserSimple();
        if (this.resourceExtensionService.userResourceListPre(logTypeCode)) {
            resourceUserSimple.setInitializedFlag(Boolean.TRUE);
            resourceUserSimple.setShowFlag(Boolean.FALSE);
            return resourceUserSimple;
        }
        Boolean initializedStatus = this.queryResourceInitialized(resourceUserSimple, regionCode, logTypeCode);
        boolean showStatus = this.resourceExtensionService.resourceShowStatusFlag(resourceUserSimple);
        if (initializedStatus.booleanValue() && showStatus) {
            List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryByResourceCodes(this.resourceExtensionService.getMqResourceCodeList(), regionCode);
            this.queryCurrentUserResourceList(resourceUserSimple, milogMiddlewareConfigs, this.resourceExtensionService.getResourceCode());
            List<MilogMiddlewareConfig> middlewareConfigEss = this.getESConfigs(regionCode);
            this.queryCurrentUserResourceList(resourceUserSimple, middlewareConfigEss, MiddlewareEnum.ELASTICSEARCH.getCode());
        }
        return resourceUserSimple;
    }

    @NotNull
    public List<MilogMiddlewareConfig> getESConfigs(String regionCode) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"area", (Object)regionCode);
        List esClusterDOS = this.milogEsClusterMapper.selectList((Wrapper)queryWrapper);
        List<MilogMiddlewareConfig> middlewareConfigEss = esClusterDOS.stream().map(MilogEsClusterDO::miLogEsResourceToConfig).collect(Collectors.toList());
        return middlewareConfigEss;
    }

    private Boolean queryResourceInitialized(ResourceUserSimple configResource, String regionCode, Integer logTypeCode) {
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryByResourceCodes(this.resourceExtensionService.getMqResourceCodeList(), regionCode);
        List<MilogMiddlewareConfig> middlewareMqConfigs = this.resourceExtensionService.currentUserConfigFilter(milogMiddlewareConfigs);
        List esClusterDOS = this.milogEsClusterMapper.selectList((Wrapper)Wrappers.lambdaQuery());
        List<MilogMiddlewareConfig> middlewareConfigEss = esClusterDOS.stream().map(logEsClusterDO -> {
            MilogMiddlewareConfig milogMiddlewareConfig = MilogEsClusterDO.miLogEsResourceToConfig(logEsClusterDO);
            return milogMiddlewareConfig;
        }).collect(Collectors.toList());
        List<MilogMiddlewareConfig> middlewareEsConfigs = this.resourceExtensionService.currentUserConfigFilter(middlewareConfigEss);
        List<Object> milogEsIndexDOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(middlewareEsConfigs)) {
            milogEsIndexDOS = this.queryMilogEsIndex(middlewareEsConfigs.stream().map(MilogMiddlewareConfig::getId).collect(Collectors.toList()), logTypeCode);
        }
        if (this.resourceExtensionService.resourceNotRequiredInit(logTypeCode, middlewareMqConfigs, middlewareEsConfigs, milogEsIndexDOS)) {
            configResource.setInitializedFlag(Boolean.TRUE);
            return Boolean.TRUE;
        }
        String msg = "";
        if (CollectionUtils.isEmpty(middlewareMqConfigs)) {
            msg = "MQ resource is not initialized";
        }
        if (CollectionUtils.isEmpty(middlewareEsConfigs) || CollectionUtils.isEmpty((Collection)milogEsIndexDOS)) {
            msg = "The ES resource is not initialized or the log index of the current type is not initialized";
        }
        configResource.setInitializedFlag(Boolean.FALSE);
        configResource.setNotInitializedMsg(String.format("%s%s", msg, ",Go to the Resource Management page to initialize resources"));
        return Boolean.FALSE;
    }

    private List<MilogEsIndexDO> queryMilogEsIndex(List<Long> clusterIds, Integer logTyCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"cluster_id", clusterIds);
        queryWrapper.eq((Object)"log_type", (Object)logTyCode);
        return this.milogEsIndexMapper.selectList((Wrapper)queryWrapper);
    }

    private void queryCurrentUserResourceList(ResourceUserSimple configResource, List<MilogMiddlewareConfig> milogMiddlewareConfigs, Integer code) {
        milogMiddlewareConfigs = this.resourceExtensionService.currentUserConfigFilter(milogMiddlewareConfigs);
        List valueKeyObjs = milogMiddlewareConfigs.stream().map(milogMiddlewareConfig -> new ValueKeyObj((Object)milogMiddlewareConfig.getId(), milogMiddlewareConfig.getAlias())).collect(Collectors.toList());
        if (Objects.equals(MiddlewareEnum.ELASTICSEARCH.getCode(), code)) {
            configResource.setStorageResourceList(valueKeyObjs);
            return;
        }
        configResource.setMqResourceList(valueKeyObjs);
    }

    @Override
    public ResourceInfo resourceDetail(Integer resourceCode, Long id) {
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), resourceCode)) {
            return this.wrapEsResourceInfo(id);
        }
        MilogMiddlewareConfig milogMiddlewareConfig = this.milogMiddlewareConfigDao.queryById(id);
        if (null != milogMiddlewareConfig) {
            return milogMiddlewareConfig.configToResourceVO();
        }
        return ResourceInfo.builder().build();
    }

    @Override
    public MilogMiddlewareConfig queryMiddlewareConfigDefault(String regionCode) {
        List<MilogMiddlewareConfig> milogMiddlewareConfigs = this.milogMiddlewareConfigDao.queryByResourceCodes(this.resourceExtensionService.getMqResourceCodeList(), regionCode);
        List<MilogMiddlewareConfig> middlewareMqConfigs = this.resourceExtensionService.currentUserConfigFilter(milogMiddlewareConfigs);
        if (CollectionUtils.isNotEmpty(middlewareMqConfigs)) {
            return middlewareMqConfigs.get(middlewareMqConfigs.size() - 1);
        }
        return null;
    }

    private ResourceInfo wrapEsResourceInfo(Long id) {
        MilogEsClusterDO esClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(id);
        if (null != esClusterDO) {
            List milogEsIndexDOS = this.milogEsIndexMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"cluster_id", (Object)esClusterDO.getId()));
            List<EsIndexVo> multipleEsIndex = milogEsIndexDOS.stream().map(MilogEsIndexDO::getLogType).distinct().sorted((val1, val2) -> null != val1 && null != val2 ? val1.compareTo((Integer)val2) : 0).map(this.getIntegerEsIndexVoFunction(milogEsIndexDOS)).collect(Collectors.toList());
            return esClusterDO.configToResourceVO(multipleEsIndex);
        }
        return ResourceInfo.builder().build();
    }

    @NotNull
    private Function<Integer, EsIndexVo> getIntegerEsIndexVoFunction(List<MilogEsIndexDO> milogEsIndexDOS) {
        return logTypeCode -> {
            EsIndexVo esIndexVo = new EsIndexVo();
            esIndexVo.setLogTypeCode(logTypeCode);
            esIndexVo.setLogTypeName(LogTypeEnum.queryNameByType((Integer)logTypeCode));
            List esIndexList = milogEsIndexDOS.stream().filter(milogEsIndexDO -> Objects.equals(logTypeCode, milogEsIndexDO.getLogType())).map(MilogEsIndexDO::getIndexName).collect(Collectors.toList());
            esIndexVo.setEsIndexList(esIndexList);
            return esIndexVo;
        };
    }

    private void updateMqResourceLabel(MilogMiddlewareConfig milogMiddlewareConfig) {
        List<String> labels = milogMiddlewareConfig.getLabels();
        if ("system".equals(milogMiddlewareConfig.getUpdater())) {
            return;
        }
        List<String> newLabels = this.mergeUserAndResourceLabels(milogMiddlewareConfig.getCreator(), milogMiddlewareConfig.getUpdater(), labels);
        milogMiddlewareConfig.setLabels(newLabels);
        this.milogMiddlewareConfigDao.updateMiddlewareConfig(milogMiddlewareConfig);
    }

    private void updateEsResourceLabel(MilogEsClusterDO clusterDO) {
        List<String> labels = clusterDO.getLabels();
        if (StringUtils.isBlank((CharSequence)clusterDO.getUpdater()) && StringUtils.isBlank((CharSequence)clusterDO.getCreator())) {
            return;
        }
        List<String> newLabels = this.mergeUserAndResourceLabels(clusterDO.getCreator(), StringUtils.isBlank((CharSequence)clusterDO.getUpdater()) ? clusterDO.getCreator() : clusterDO.getUpdater(), labels);
        clusterDO.setLabels(newLabels);
        this.milogEsClusterMapper.updateById(clusterDO);
    }

    private List<String> mergeUserAndResourceLabels(String creatorUId, String updaterUId, List<String> existLabels) {
        List<String> resourceDeptLabels = this.resourceExtensionService.generateResourceLabels(updaterUId);
        if (!Objects.equals(creatorUId, updaterUId) && CollectionUtils.isNotEmpty(existLabels) && !CollUtil.containsAll(existLabels, resourceDeptLabels)) {
            existLabels.addAll(resourceDeptLabels);
        }
        return existLabels;
    }

    private void addResource(MiLogResource miLogResource) {
        List<String> resourceDeptLabels = this.resourceExtensionService.generateResourceLabels(MoneUserContext.getCurrentUser().getUser());
        resourceDeptLabels.addAll(miLogResource.getLabels());
        miLogResource.setLabels(resourceDeptLabels);
        this.resourceExtensionService.addResourcePreProcessing(resourceDeptLabels, miLogResource);
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), miLogResource.getResourceCode())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)LogStorageTypeEnum.ELASTICSEARCH.name(), (CharSequence)miLogResource.getStorageType())) {
                this.checkEsAddressPortOperate(miLogResource);
                this.addEsResourceInfo(miLogResource);
                return;
            }
            this.addOtherResourceInfo(miLogResource);
            return;
        }
        this.resourceExtensionService.addResourceMiddleProcessing(miLogResource);
        MilogMiddlewareConfig milogMiddlewareConfig = MilogMiddlewareConfig.miLogMqResourceToConfig(miLogResource);
        this.wrapBaseCommon(milogMiddlewareConfig, OperateEnum.ADD_OPERATE);
        this.resourceExtensionService.addResourcePostProcessing(milogMiddlewareConfig);
        this.milogMiddlewareConfigDao.addMiddlewareConfig(milogMiddlewareConfig);
    }

    private void addOtherResourceInfo(MiLogResource miLogResource) {
        MilogEsClusterDO esClusterDO = MilogEsClusterDO.miLogEsResourceToConfig(miLogResource);
        this.wrapBaseCommon(esClusterDO, OperateEnum.ADD_OPERATE);
        this.resourceExtensionService.addEsResourcePreProcessing(esClusterDO);
        this.milogEsClusterMapper.insert(esClusterDO);
        this.esPlugin.initializeLogStorage(esClusterDO);
    }

    private void addEsResourceInfo(MiLogResource miLogResource) {
        MilogEsClusterDO esClusterDO = MilogEsClusterDO.miLogEsResourceToConfig(miLogResource);
        this.wrapBaseCommon(esClusterDO, OperateEnum.ADD_OPERATE);
        this.resourceExtensionService.addEsResourcePreProcessing(esClusterDO);
        this.milogEsClusterMapper.insert(esClusterDO);
        this.addEsIndex(esClusterDO.getId(), miLogResource.getMultipleEsIndex());
        this.esPlugin.initializeLogStorage(esClusterDO);
    }

    private void checkAlias(MiLogResource resource, OperateEnum operateEnum) {
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), resource.getResourceCode())) {
            List<MilogEsClusterDO> logEsClusterDOS = this.milogEsClusterMapper.selectByAlias(resource.getAlias());
            if (operateEnum == OperateEnum.ADD_OPERATE && CollectionUtils.isNotEmpty(logEsClusterDOS)) {
                throw new MilogManageException("alias has exists,please refill");
            }
            if (operateEnum == OperateEnum.UPDATE_OPERATE && CollectionUtils.isNotEmpty(logEsClusterDOS)) {
                MilogEsClusterDO logEsClusterDO = logEsClusterDOS.get(logEsClusterDOS.size() - 1);
                if (!Objects.equals(resource.getId(), logEsClusterDO.getId())) {
                    throw new MilogManageException("alias has exists,please refill");
                }
            }
        }
        if (MiddlewareEnum.ROCKETMQ.getCode().equals(resource.getResourceCode())) {
            List<MilogMiddlewareConfig> middlewareConfigs = this.milogMiddlewareConfigDao.selectByAlias(resource.getAlias());
            if (operateEnum == OperateEnum.ADD_OPERATE && CollectionUtils.isNotEmpty(middlewareConfigs)) {
                throw new MilogManageException("alias has exists,please refill");
            }
            if (operateEnum == OperateEnum.UPDATE_OPERATE && CollectionUtils.isNotEmpty(middlewareConfigs)) {
                MilogMiddlewareConfig middlewareConfig = middlewareConfigs.get(middlewareConfigs.size() - 1);
                if (!Objects.equals(resource.getId(), middlewareConfig.getId())) {
                    throw new MilogManageException("alias has exists,please refill");
                }
            }
        }
    }

    private void addEsIndex(Long esClusterId, List<EsIndexVo> multipleEsIndex) {
        ArrayList milogEsIndexDOS = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(multipleEsIndex)) {
            for (EsIndexVo esIndexVo : multipleEsIndex) {
                milogEsIndexDOS.addAll(MilogEsIndexDO.essIndexVoToIndexDO(esClusterId, esIndexVo));
            }
        }
        for (MilogEsIndexDO milogEsIndexDO : milogEsIndexDOS) {
            this.milogEsIndexMapper.insert(milogEsIndexDO);
        }
    }

    private void updateResource(MiLogResource miLogResource) {
        if (Objects.equals(ResourceEnum.STORAGE.getCode(), miLogResource.getResourceCode())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)LogStorageTypeEnum.ELASTICSEARCH.name(), (CharSequence)miLogResource.getStorageType())) {
                boolean changed = this.authenticationInChanged((MilogEsClusterDO)this.milogEsClusterMapper.selectById(miLogResource.getId()), miLogResource);
                this.checkEsAddressPortOperate(miLogResource);
                MilogEsClusterDO esClusterDO = MilogEsClusterDO.miLogEsResourceToConfig(miLogResource);
                esClusterDO.setId(miLogResource.getId());
                this.resourceExtensionService.addEsResourcePreProcessing(esClusterDO);
                this.milogEsClusterMapper.updateById(esClusterDO);
                this.handleEsIndexStore(miLogResource, esClusterDO.getId(), changed);
                this.esPlugin.initializeLogStorage(esClusterDO);
                return;
            }
            MilogEsClusterDO esClusterDO = MilogEsClusterDO.miLogEsResourceToConfig(miLogResource);
            esClusterDO.setId(miLogResource.getId());
            this.resourceExtensionService.addEsResourcePreProcessing(esClusterDO);
            this.milogEsClusterMapper.updateById(esClusterDO);
            this.esPlugin.initializeLogStorage(esClusterDO);
            return;
        }
        this.updateCompareMqInfo(miLogResource);
        MilogMiddlewareConfig milogMiddlewareConfig = MilogMiddlewareConfig.miLogMqResourceToConfig(miLogResource);
        this.buildCommonAttr(miLogResource.getId(), milogMiddlewareConfig);
        this.milogMiddlewareConfigDao.updateMiddlewareConfig(milogMiddlewareConfig);
    }

    private boolean authenticationInChanged(MilogEsClusterDO clusterDO, MiLogResource miLogResource) {
        if (!Objects.equals(clusterDO.getConWay(), miLogResource.getConWay())) {
            return true;
        }
        if (Objects.equals("pwd", miLogResource.getConWay())) {
            return !Objects.equals(clusterDO.getUser(), miLogResource.getAk()) || !Objects.equals(clusterDO.getPwd(), miLogResource.getSk());
        }
        if (Objects.equals("token", miLogResource.getConWay())) {
            return !Objects.equals(clusterDO.getToken(), miLogResource.getEsToken()) || !Objects.equals(clusterDO.getDtCatalog(), miLogResource.getCatalog()) || !Objects.equals(clusterDO.getDtDatabase(), miLogResource.getDatabase());
        }
        return false;
    }

    private void handleEsIndexStore(MiLogResource miLogResource, Long esClusterId, boolean changed) {
        this.handleEsIndex(esClusterId, miLogResource.getMultipleEsIndex());
        if (changed) {
            List<MilogLogStoreDO> storeDOS = this.logstoreDao.queryByEsInfo(miLogResource.getRegionEn(), esClusterId);
            if (changed && CollectionUtils.isNotEmpty(storeDOS)) {
                for (MilogLogStoreDO storeDO : storeDOS) {
                    this.logTail.handleStoreTail(storeDO.getId());
                }
            }
        }
    }

    private void handleEsIndex(Long esClusterId, List<EsIndexVo> multipleEsIndex) {
        for (EsIndexVo esIndex : multipleEsIndex) {
            this.doHandleEsIndexByLogType(esClusterId, esIndex.getLogTypeCode(), esIndex.getEsIndexList());
        }
    }

    private void doHandleEsIndexByLogType(Long esClusterId, Integer logTypeCode, List<String> esIndexList) {
        List<MilogEsIndexDO> addExIndexDo;
        ArrayList delExIndexDo = Lists.newArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"cluster_id", (Object)esClusterId);
        queryWrapper.eq((Object)"log_type", (Object)logTypeCode);
        List existEsIndexDO = this.milogEsIndexMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)existEsIndexDO)) {
            addExIndexDo = esIndexList.stream().map(indexName -> this.getMilogEsIndexDO(esClusterId, logTypeCode, (String)indexName)).collect(Collectors.toList());
        } else {
            for (MilogEsIndexDO milogEsIndexDO : existEsIndexDO) {
                if (esIndexList.contains(milogEsIndexDO.getIndexName())) continue;
                delExIndexDo.add(milogEsIndexDO);
            }
            List existIndexes = existEsIndexDO.stream().map(MilogEsIndexDO::getIndexName).collect(Collectors.toList());
            addExIndexDo = esIndexList.stream().filter(indexName -> !existIndexes.contains(indexName)).map(indexName -> this.getMilogEsIndexDO(esClusterId, logTypeCode, (String)indexName)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)delExIndexDo)) {
            this.milogEsIndexMapper.deleteBatchIds(delExIndexDo.stream().map(MilogEsIndexDO::getId).collect(Collectors.toList()));
        }
        this.addExIndex(addExIndexDo);
    }

    private void addExIndex(List<MilogEsIndexDO> addExIndexDo) {
        for (MilogEsIndexDO milogEsIndexDO : addExIndexDo) {
            this.milogEsIndexMapper.insert(milogEsIndexDO);
        }
    }

    @NotNull
    private MilogEsIndexDO getMilogEsIndexDO(Long esClusterId, Integer logTypeCode, String indexName) {
        MilogEsIndexDO milogEsIndexDO = new MilogEsIndexDO();
        milogEsIndexDO.setClusterId(esClusterId);
        milogEsIndexDO.setLogType(logTypeCode);
        milogEsIndexDO.setIndexName(indexName);
        return milogEsIndexDO;
    }

    private void buildCommonAttr(Long resourceId, MilogMiddlewareConfig milogMiddlewareConfig) {
        MilogMiddlewareConfig existConfig = this.milogMiddlewareConfigDao.queryById(resourceId);
        milogMiddlewareConfig.setCtime(existConfig.getCtime());
        milogMiddlewareConfig.setCreator(existConfig.getCreator());
        this.wrapBaseCommon(milogMiddlewareConfig, OperateEnum.UPDATE_OPERATE);
        this.resourceExtensionService.addResourcePostProcessing(milogMiddlewareConfig);
        milogMiddlewareConfig.setId(resourceId);
    }

    private void deleteEsIndex(Long esClusterId) {
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"cluster_id", (Object)esClusterId);
        this.milogEsIndexMapper.delete((Wrapper)deleteWrapper);
    }

    private void updateCompareMqInfo(MiLogResource miLogResource) {
        MilogMiddlewareConfig config = this.milogMiddlewareConfigDao.queryById(miLogResource.getId());
        if (!(Objects.equals(miLogResource.getAk(), config.getAk()) && Objects.equals(miLogResource.getSk(), config.getSk()) && Objects.equals(miLogResource.getServiceUrl(), config.getServiceUrl()) && Objects.equals(miLogResource.getOrgId(), config.getOrgId()) && Objects.equals(miLogResource.getTeamId(), config.getTeamId()))) {
            this.resourceExtensionService.addResourceMiddleProcessing(miLogResource);
        }
    }

    private void baseMiddlewareConfigAssemble(MiddlewareAddParam param, MilogMiddlewareConfig middlewareConfig) {
        middlewareConfig.setType(param.getType());
        middlewareConfig.setRegionEn(param.getRegionEn());
        middlewareConfig.setAlias(param.getAlias());
        middlewareConfig.setNameServer(param.getNameServer());
        middlewareConfig.setServiceUrl(param.getServiceUrl());
        middlewareConfig.setAk(param.getAk());
        middlewareConfig.setSk(param.getSk());
        middlewareConfig.setAuthorization(param.getAuthorization());
        middlewareConfig.setOrgId(param.getOrgId());
        middlewareConfig.setTeamId(param.getTeamId());
        middlewareConfig.setIsDefault(param.getIsDefault());
    }

    private MilogMiddlewareConfig AddParamToAddEntity(MiddlewareAddParam addParam) {
        MilogMiddlewareConfig middlewareConfig = new MilogMiddlewareConfig();
        this.baseMiddlewareConfigAssemble(addParam, middlewareConfig);
        middlewareConfig.setCtime(Instant.now().toEpochMilli());
        middlewareConfig.setUtime(Instant.now().toEpochMilli());
        middlewareConfig.setCreator(MoneUserContext.getCurrentUser().getUser());
        middlewareConfig.setUpdater(MoneUserContext.getCurrentUser().getUser());
        return middlewareConfig;
    }

    private MilogMiddlewareConfig updateParamToUpdateEntity(MiddlewareUpdateParam updateParam, MilogMiddlewareConfig middlewareConfig) {
        this.baseMiddlewareConfigAssemble(updateParam, middlewareConfig);
        middlewareConfig.setUtime(Instant.now().toEpochMilli());
        middlewareConfig.setUpdater(MoneUserContext.getCurrentUser().getUser());
        return middlewareConfig;
    }

    private List<String> preCheckMiddlewareConfig(MiddlewareAddParam param) {
        ArrayList msg = Lists.newArrayList();
        if (null == param) {
            msg.add("addParam can not be null");
            return msg;
        }
        List<?> types = param.getTypes();
        if (CollectionUtils.isEmpty(types) || types.size() != 2) {
            msg.add("types can not be null");
            return msg;
        }
        param.setType(((Double)types.get(0)).intValue());
        param.setRegionEn((String)types.get(1));
        if (null == param.getType()) {
            msg.add("region can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)param.getNameServer())) {
            msg.add("nameServer can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)param.getServiceUrl()) && this.accurateTypes.contains(param.getType())) {
            msg.add("serviceUrl can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)param.getAk()) && this.accurateTypes.contains(param.getType())) {
            msg.add("ak can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)param.getSk()) && this.accurateTypes.contains(param.getType())) {
            msg.add("sk can not be null");
        }
        if (MiddlewareEnum.ROCKETMQ.getCode().equals(param.getType()) && StringUtils.isEmpty((CharSequence)param.getAuthorization())) {
            msg.add("authorization can not be null");
        }
        if (StringUtils.isEmpty((CharSequence)param.getOrgId()) && this.accurateTypes.contains(param.getType())) {
            msg.add("orgId can not be null");
        }
        if (MiddlewareEnum.ROCKETMQ.getCode().equals(param.getType()) && StringUtils.isEmpty((CharSequence)param.getTeamId())) {
            msg.add("teamId can not be null");
        }
        return msg;
    }

    private List<String> preCheckUpdateMiddlewareConfig(MiddlewareUpdateParam updateParam) {
        List<String> checkMsg = this.preCheckMiddlewareConfig(updateParam);
        if (null == updateParam.getId()) {
            checkMsg.add("ID can not null");
        }
        return checkMsg;
    }

    private Condition handleParamToCondition(MiddlewareQueryParam param) {
        Cnd cnd = Cnd.NEW();
        int size = 2;
        List<?> types = param.getTypes();
        if (CollectionUtils.isNotEmpty(param.getTypes()) && null != types.get(0)) {
            cnd.and("type", "=", (Object)((Double)types.get(0)).intValue());
        }
        if (CollectionUtils.isNotEmpty(param.getTypes()) && types.size() == size && null != types.get(1)) {
            cnd.and("region_en", "=", types.get(1));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAlias())) {
            cnd.and("alias", "like", (Object)("%" + param.getAlias() + "%"));
        }
        cnd.orderBy("ctime", "desc");
        return cnd;
    }
}

