/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.es.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.xiaomi.mone.es.EsClient;
import com.xiaomi.mone.es.EsProcessor;
import com.xiaomi.mone.es.ProcessorConf;
import javax.annotation.Resource;
import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.extension.es.EsDataSourceService;
import org.apache.ozhera.trace.etl.extension.es.EsTraceUtil;
import org.apache.ozhera.trace.etl.extension.es.QueryEsService;
import org.apache.ozhera.trace.etl.extension.es.WriteEsService;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"storage.type"}, havingValue="es")
public class EsProcessConfig {
    private static final Logger log = LoggerFactory.getLogger(EsProcessConfig.class);
    @Resource(name="jaegerEsClient")
    private EsClient esClient;
    @Resource(name="errorEsClient")
    private EsClient errorEsClient;
    @NacosValue(value="${es.bulk_actions}")
    private int bulkActions;
    @NacosValue(value="${es.byte_size}")
    private int byteSize;
    @NacosValue(value="${es.concurrent_request}")
    private int concurRequest;
    @NacosValue(value="${es.flush_interval}")
    private int flushInterval;
    @NacosValue(value="${es.retry_num}")
    private int retryNum;
    @NacosValue(value="${es.retry_interval}")
    private int retryInterval;

    @Bean
    public EsProcessor esProcessor() {
        return new EsProcessor(new ProcessorConf(this.bulkActions, (long)this.byteSize, this.concurRequest, this.flushInterval, this.retryNum, this.retryInterval, this.esClient, new BulkProcessor.Listener(this){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                log.error("fail send {} message to es,desc:{},failure:{}", new Object[]{request.numberOfActions(), request.getDescription(), failure});
            }
        }));
    }

    @Bean(value={"errorEsProcessor"})
    public EsProcessor errorEsProcessor() {
        return new EsProcessor(new ProcessorConf(this.bulkActions, (long)this.byteSize, this.concurRequest, this.flushInterval, this.retryNum, this.retryInterval, this.errorEsClient, new BulkProcessor.Listener(this){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                log.error("fail send {} error trace message to es,desc:{},failure:{}", new Object[]{request.numberOfActions(), request.getDescription(), failure});
            }
        }));
    }

    @Bean
    public DataSourceService getDataSourceService() {
        return new EsDataSourceService();
    }

    @Bean
    public EsTraceUtil getEsTraceUtil() {
        return new EsTraceUtil();
    }

    @Bean
    public QueryEsService getQueryEsService() {
        return new QueryEsService();
    }

    @Bean
    public WriteEsService getWriteEsService() {
        return new WriteEsService();
    }
}

