/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.TypedPropertyHolder;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class ConnectionFactoryConfiguration
extends TypedPropertyHolder {
    public void validate(List<String> errors) {
        if (this.getConfigurationType() == null || "DEFAULT".equals(this.getConfigurationType())) {
            if (!StringUtility.stringHasValue(this.getProperty("driverClass"))) {
                errors.add(Messages.getString("ValidationError.18", "connectionFactory", "driverClass"));
            }
            if (!StringUtility.stringHasValue(this.getProperty("connectionURL"))) {
                errors.add(Messages.getString("ValidationError.18", "connectionFactory", "connectionURL"));
            }
        }
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("connectionFactory");
        if (StringUtility.stringHasValue(this.getConfigurationType())) {
            xmlElement.addAttribute(new Attribute("type", this.getConfigurationType()));
        }
        this.addPropertyXmlElements(xmlElement);
        return xmlElement;
    }
}

