/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.mapstruct.ap.internal.model.AbstractMappingMethodBuilder;
import org.mapstruct.ap.internal.model.ContainerMappingMethod;
import org.mapstruct.ap.internal.model.ForgedMethod;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public abstract class ContainerMappingMethodBuilder<B extends ContainerMappingMethodBuilder<B, M>, M extends ContainerMappingMethod>
extends AbstractMappingMethodBuilder<B, M> {
    private SelectionParameters selectionParameters;
    private FormattingParameters formattingParameters;
    private String errorMessagePart;
    private String callingContextTargetPropertyName;
    private AnnotationMirror positionHint;

    ContainerMappingMethodBuilder(Class<B> selfType, String errorMessagePart) {
        super(selfType);
        this.errorMessagePart = errorMessagePart;
    }

    public B formattingParameters(FormattingParameters formattingParameters) {
        this.formattingParameters = formattingParameters;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B selectionParameters(SelectionParameters selectionParameters) {
        this.selectionParameters = selectionParameters;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B callingContextTargetPropertyName(String callingContextTargetPropertyName) {
        this.callingContextTargetPropertyName = callingContextTargetPropertyName;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    public B positionHint(AnnotationMirror positionHint) {
        this.positionHint = positionHint;
        return (B)((ContainerMappingMethodBuilder)this.myself);
    }

    @Override
    public final M build() {
        Type sourceParameterType = Collections.first(this.method.getSourceParameters()).getType();
        Type resultType = this.method.getResultType();
        Type sourceElementType = this.getElementType(sourceParameterType);
        Type targetElementType = this.getElementType(resultType);
        String loopVariableName = Strings.getSafeVariableName(sourceElementType.getName(), this.method.getParameterNames());
        SourceRHS sourceRHS = new SourceRHS(loopVariableName, sourceElementType, new HashSet<String>(), this.errorMessagePart);
        SelectionCriteria criteria = SelectionCriteria.forMappingMethods(this.selectionParameters, this.method.getOptions().getIterableMapping().getMappingControl(this.ctx.getElementUtils()), this.callingContextTargetPropertyName, false);
        Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, this.getDescription(), targetElementType, this.formattingParameters, criteria, sourceRHS, this.positionHint, () -> this.forge(sourceRHS, sourceElementType, targetElementType));
        if (assignment == null) {
            if (this.method instanceof ForgedMethod) {
                return null;
            }
            this.reportCannotCreateMapping(this.method, String.format("%s \"%s\"", sourceRHS.getSourceErrorMessagePart(), sourceRHS.getSourceType().describe()), sourceRHS.getSourceType(), targetElementType, "");
        } else {
            this.ctx.getMessager().note(2, Message.ITERABLEMAPPING_SELECT_ELEMENT_NOTE, assignment);
            if (this.method instanceof ForgedMethod) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                forgedMethod.addThrownTypes(assignment.getThrownTypes());
            }
        }
        assignment = this.getWrapper(assignment, this.method);
        boolean mapNullToDefault = this.method.getOptions().getIterableMapping().getNullValueMappingStrategy().isReturnDefault();
        MethodReference factoryMethod = null;
        if (!this.method.isUpdateMethod()) {
            factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, null, this.ctx);
        }
        HashSet<String> existingVariables = new HashSet<String>(this.method.getParameterNames());
        existingVariables.add(loopVariableName);
        List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, this.selectionParameters, this.ctx, existingVariables);
        List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, this.selectionParameters, this.ctx, existingVariables);
        return this.instantiateMappingMethod(this.method, existingVariables, assignment, factoryMethod, mapNullToDefault, loopVariableName, beforeMappingMethods, afterMappingMethods, this.selectionParameters);
    }

    private Assignment forge(SourceRHS sourceRHS, Type sourceType, Type targetType) {
        Assignment assignment = super.forgeMapping(sourceRHS, sourceType, targetType);
        if (assignment != null) {
            this.ctx.getMessager().note(2, Message.ITERABLEMAPPING_CREATE_ELEMENT_NOTE, assignment);
        }
        return assignment;
    }

    protected abstract M instantiateMappingMethod(Method var1, Collection<String> var2, Assignment var3, MethodReference var4, boolean var5, String var6, List<LifecycleCallbackMethodReference> var7, List<LifecycleCallbackMethodReference> var8, SelectionParameters var9);

    protected abstract Type getElementType(Type var1);

    protected abstract Assignment getWrapper(Assignment var1, Method var2);

    @Override
    protected boolean shouldUsePropertyNamesInHistory() {
        return false;
    }
}

