/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.ParentChildInnerHitContextBuilder;
import org.elasticsearch.search.SearchService;

public class HasParentQueryBuilder
extends AbstractQueryBuilder<HasParentQueryBuilder> {
    public static final String NAME = "has_parent";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField PARENT_TYPE_FIELD = new ParseField("parent_type", new String[0]);
    private static final ParseField SCORE_FIELD = new ParseField("score", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String type;
    private final boolean score;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public HasParentQueryBuilder(String type, QueryBuilder query, boolean score) {
        this(type, query, score, null);
    }

    private HasParentQueryBuilder(String type, QueryBuilder query, boolean score, InnerHitBuilder innerHitBuilder) {
        this.type = (String)HasParentQueryBuilder.requireValue((Object)type, (String)("[has_parent] requires '" + PARENT_TYPE_FIELD.getPreferredName() + "' field"));
        this.query = (QueryBuilder)HasParentQueryBuilder.requireValue((Object)query, (String)("[has_parent] requires '" + QUERY_FIELD.getPreferredName() + "' field"));
        this.score = score;
        this.innerHitBuilder = innerHitBuilder;
    }

    public HasParentQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.score = in.readBoolean();
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = (InnerHitBuilder)in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeBoolean(this.score);
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean score() {
        return this.score;
    }

    public String type() {
        return this.type;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasParentQueryBuilder innerHit(InnerHitBuilder innerHit) {
        this.innerHitBuilder = innerHit;
        this.innerHitBuilder.setIgnoreUnmapped(this.ignoreUnmapped);
        return this;
    }

    public HasParentQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.setIgnoreUnmapped(ignoreUnmapped);
        }
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("[joining] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.getMapperService());
        if (joinFieldMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[has_parent] no join field has been configured", new Object[0]);
        }
        ParentIdFieldMapper parentIdFieldMapper = joinFieldMapper.getParentIdFieldMapper(this.type, true);
        if (parentIdFieldMapper != null) {
            Query parentFilter = parentIdFieldMapper.getParentFilter();
            BooleanQuery innerQuery = Queries.filtered((Query)this.query.toQuery(context), (Query)parentFilter);
            Query childFilter = parentIdFieldMapper.getChildrenFilter();
            MappedFieldType fieldType = parentIdFieldMapper.fieldType();
            SortedSetOrdinalsIndexFieldData fieldData = (SortedSetOrdinalsIndexFieldData)context.getForField(fieldType);
            return new HasChildQueryBuilder.LateParsingQuery(childFilter, (Query)innerQuery, 1, Integer.MAX_VALUE, fieldType.name(), this.score ? ScoreMode.Max : ScoreMode.None, fieldData, context.getSearchSimilarity());
        }
        if (this.ignoreUnmapped) {
            return new MatchNoDocsQuery();
        }
        throw new QueryShardException(context, "[has_parent] join field [" + joinFieldMapper.name() + "] doesn't hold [" + this.type + "] as a parent", new Object[0]);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PARENT_TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SCORE_FIELD.getPreferredName(), this.score);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), (ToXContent)this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static HasParentQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        InnerHitBuilder innerHits = null;
        boolean ignoreUnmapped = false;
        String currentFieldName = null;
        QueryBuilder iqb = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    iqb = HasParentQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    innerHits = InnerHitBuilder.fromXContent((XContentParser)parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (PARENT_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                parentType = parser.text();
                continue;
            }
            if (SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                score = parser.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        HasParentQueryBuilder queryBuilder = (HasParentQueryBuilder)((HasParentQueryBuilder)new HasParentQueryBuilder(parentType, iqb, score).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        if (innerHits != null) {
            queryBuilder.innerHit(innerHits);
        }
        return queryBuilder;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean doEquals(HasParentQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.type, that.type) && Objects.equals(this.score, that.score) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.type, this.score, this.innerHitBuilder, this.ignoreUnmapped);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryShardContext);
        if (rewrittenQuery != this.query) {
            HasParentQueryBuilder hasParentQueryBuilder = new HasParentQueryBuilder(this.type, rewrittenQuery, this.score, this.innerHitBuilder);
            hasParentQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasParentQueryBuilder;
        }
        return this;
    }

    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            String name;
            String string = name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.type;
            if (innerHits.containsKey(name)) {
                throw new IllegalArgumentException("[inner_hits] already contains an entry for key [" + name + "]");
            }
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.extractInnerHits((QueryBuilder)this.query, children);
            ParentChildInnerHitContextBuilder innerHitContextBuilder = new ParentChildInnerHitContextBuilder(this.type, false, this.query, this.innerHitBuilder, children);
            innerHits.put(name, innerHitContextBuilder);
        }
    }
}

