/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.udp;

import com.xiaomi.data.push.udp.handler.UdpServerHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpServer {
    private static final Logger log = LoggerFactory.getLogger(UdpServer.class);
    private String host;
    private int port;
    private Function<String, String> function;
    private Channel channel;
    private NioEventLoopGroup acceptGroup;

    public UdpServer(String host, int port, Function<String, String> function) {
        this.host = host;
        this.port = port;
        this.function = function;
    }

    public void start() throws InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        this.acceptGroup = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.acceptGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new UdpServerHandler(UdpServer.this.function)});
            }
        });
        this.channel = bootstrap.bind(this.host, this.port).sync().channel();
        log.info("UdpServer start success port:{}", (Object)this.port);
    }

    public void await() throws InterruptedException {
        this.channel.closeFuture().await();
    }

    public void shutdown() {
        this.acceptGroup.shutdownGracefully();
    }
}

