/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.udp.handler;

import com.xiaomi.data.push.udp.po.UdpMsg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpClientHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger(UdpClientHandler.class);
    private Consumer<UdpMsg> consumer;

    public UdpClientHandler(Consumer<UdpMsg> consumer) {
        this.consumer = consumer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
        ByteBuf buf = (ByteBuf)msg.content();
        int readableBytes = buf.readableBytes();
        byte[] content = new byte[readableBytes];
        buf.readBytes(content);
        String res = new String(content);
        this.consumer.accept(new UdpMsg(res, ((InetSocketAddress)msg.sender()).getAddress().getHostAddress()));
    }
}

