/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.service.impl;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.seata.console.utils.JwtTokenUtils;
import org.apache.seata.mcp.service.ModifyConfirmService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ModifyConfirmServiceImpl
implements ModifyConfirmService {
    private final JwtTokenUtils jwtTokenUtils;
    private static final long MODIFY_TOKEN_VALIDITY_IN_MILLISECONDS = 180000L;
    @Value(value="${seata.security.secretKey}")
    private String secretKey;

    public ModifyConfirmServiceImpl(JwtTokenUtils jwtTokenUtils) {
        this.jwtTokenUtils = jwtTokenUtils;
    }

    @Override
    public Map<String, String> confirmAndGetKey() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long now = new Date().getTime();
        Date expirationDate = new Date(now + 180000L);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])Decoders.BASE64.decode((Object)this.secretKey), SignatureAlgorithm.HS256.getJcaName());
        String key = Jwts.builder().setSubject(authentication.getName()).claim("modify", (Object)"").setExpiration(expirationDate).signWith((Key)secretKeySpec, SignatureAlgorithm.HS256).compact();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modify_key", key);
        map.put("Important!!!", "You need to repeat the content to be modified by the user and get confirmation from the user before you can continue to call the modification tool");
        return map;
    }

    @Override
    public Boolean isValidKey(String key) {
        return this.jwtTokenUtils.validateToken(key);
    }
}

