/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import org.apache.fory.Fory;
import org.apache.fory.codegen.Expression;
import org.apache.fory.config.LongEncoding;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.ImmutableSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;

public class PrimitiveSerializers {
    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(Boolean.TYPE, new BooleanSerializer(fory, (Class<?>)Boolean.TYPE));
        resolver.registerSerializer(Byte.TYPE, new ByteSerializer(fory, (Class<?>)Byte.TYPE));
        resolver.registerSerializer(Short.TYPE, new ShortSerializer(fory, (Class<?>)Short.TYPE));
        resolver.registerSerializer(Character.TYPE, new CharSerializer(fory, (Class<?>)Character.TYPE));
        resolver.registerSerializer(Integer.TYPE, new IntSerializer(fory, (Class<?>)Integer.TYPE));
        resolver.registerSerializer(Long.TYPE, new LongSerializer(fory, (Class<?>)Long.TYPE));
        resolver.registerSerializer(Float.TYPE, new FloatSerializer(fory, (Class<?>)Float.TYPE));
        resolver.registerSerializer(Double.TYPE, new DoubleSerializer(fory, (Class<?>)Double.TYPE));
        resolver.registerSerializer(Boolean.class, new BooleanSerializer(fory, Boolean.class));
        resolver.registerSerializer(Byte.class, new ByteSerializer(fory, Byte.class));
        resolver.registerSerializer(Short.class, new ShortSerializer(fory, Short.class));
        resolver.registerSerializer(Character.class, new CharSerializer(fory, Character.class));
        resolver.registerSerializer(Integer.class, new IntSerializer(fory, Integer.class));
        resolver.registerSerializer(Long.class, new LongSerializer(fory, Long.class));
        resolver.registerSerializer(Float.class, new FloatSerializer(fory, Float.class));
        resolver.registerSerializer(Double.class, new DoubleSerializer(fory, Double.class));
    }

    public static final class DoubleSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Double> {
        public DoubleSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Double value) {
            buffer.writeFloat64(value);
        }

        @Override
        public Double read(MemoryBuffer buffer) {
            return buffer.readFloat64();
        }
    }

    public static final class FloatSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Float> {
        public FloatSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Float value) {
            buffer.writeFloat32(value.floatValue());
        }

        @Override
        public Float read(MemoryBuffer buffer) {
            return Float.valueOf(buffer.readFloat32());
        }
    }

    public static final class LongSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Long> {
        private final LongEncoding longEncoding;

        public LongSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
            this.longEncoding = fory.longEncoding();
        }

        @Override
        public void write(MemoryBuffer buffer, Long value) {
            LongSerializer.writeInt64(buffer, value, this.longEncoding);
        }

        @Override
        public Long read(MemoryBuffer buffer) {
            return LongSerializer.readInt64(buffer, this.longEncoding);
        }

        public static Expression writeInt64(Expression buffer, Expression v, LongEncoding longEncoding, boolean ensureBounds) {
            switch (longEncoding) {
                case LE_RAW_BYTES: {
                    return new Expression.Invoke(buffer, "writeInt64", v);
                }
                case SLI: {
                    return new Expression.Invoke(buffer, ensureBounds ? "writeSliInt64" : "_unsafeWriteSliInt64", v);
                }
                case PVL: {
                    return new Expression.Invoke(buffer, ensureBounds ? "writeVarInt64" : "_unsafeWriteVarInt64", v);
                }
            }
            throw new UnsupportedOperationException("Unsupported long encoding " + (Object)((Object)longEncoding));
        }

        public static void writeInt64(MemoryBuffer buffer, long value, LongEncoding longEncoding) {
            if (longEncoding == LongEncoding.SLI) {
                buffer.writeSliInt64(value);
            } else if (longEncoding == LongEncoding.LE_RAW_BYTES) {
                buffer.writeInt64(value);
            } else {
                buffer.writeVarInt64(value);
            }
        }

        public static long readInt64(MemoryBuffer buffer, LongEncoding longEncoding) {
            if (longEncoding == LongEncoding.SLI) {
                return buffer.readSliInt64();
            }
            if (longEncoding == LongEncoding.LE_RAW_BYTES) {
                return buffer.readInt64();
            }
            return buffer.readVarInt64();
        }

        public static Expression readInt64(Expression buffer, LongEncoding longEncoding) {
            return new Expression.Invoke(buffer, LongSerializer.readLongFunc(longEncoding), TypeUtils.PRIMITIVE_LONG_TYPE);
        }

        public static String readLongFunc(LongEncoding longEncoding) {
            switch (longEncoding) {
                case LE_RAW_BYTES: {
                    return Platform.IS_LITTLE_ENDIAN ? "_readInt64OnLE" : "_readInt64OnBE";
                }
                case SLI: {
                    return Platform.IS_LITTLE_ENDIAN ? "_readSliInt64OnLE" : "_readSliInt64OnBE";
                }
                case PVL: {
                    return Platform.IS_LITTLE_ENDIAN ? "_readVarInt64OnLE" : "_readVarInt64OnBE";
                }
            }
            throw new UnsupportedOperationException("Unsupported long encoding " + (Object)((Object)longEncoding));
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Long value) {
            buffer.writeVarInt64(value);
        }

        @Override
        public Long xread(MemoryBuffer buffer) {
            return buffer.readVarInt64();
        }
    }

    public static final class IntSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Integer> {
        private final boolean compressNumber;

        public IntSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
            this.compressNumber = fory.compressInt();
        }

        @Override
        public void write(MemoryBuffer buffer, Integer value) {
            if (this.compressNumber) {
                buffer.writeVarInt32(value);
            } else {
                buffer.writeInt32(value);
            }
        }

        @Override
        public Integer read(MemoryBuffer buffer) {
            if (this.compressNumber) {
                return buffer.readVarInt32();
            }
            return buffer.readInt32();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            buffer.writeVarInt32(value);
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            return buffer.readVarInt32();
        }
    }

    public static final class ShortSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Short> {
        public ShortSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Short value) {
            buffer.writeInt16(value);
        }

        @Override
        public Short read(MemoryBuffer buffer) {
            return buffer.readInt16();
        }
    }

    public static final class CharSerializer
    extends ImmutableSerializer<Character> {
        public CharSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Character value) {
            buffer.writeChar(value.charValue());
        }

        @Override
        public Character read(MemoryBuffer buffer) {
            return Character.valueOf(buffer.readChar());
        }
    }

    public static final class Uint16Serializer
    extends Serializer<Integer> {
        public Uint16Serializer(Fory fory) {
            super(fory, Integer.class);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument(value >= 0 && value <= 65535);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 16;
        }
    }

    public static final class Uint8Serializer
    extends Serializer<Integer> {
        public Uint8Serializer(Fory fory) {
            super(fory, Integer.class);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument(value >= 0 && value <= 255);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 24;
        }
    }

    public static final class ByteSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Byte> {
        public ByteSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Byte value) {
            buffer.writeByte(value);
        }

        @Override
        public Byte read(MemoryBuffer buffer) {
            return buffer.readByte();
        }
    }

    public static final class BooleanSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Boolean> {
        public BooleanSerializer(Fory fory, Class<?> cls) {
            super(fory, cls, !cls.isPrimitive() && !fory.isBasicTypesRefIgnored(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Boolean value) {
            buffer.writeBoolean(value);
        }

        @Override
        public Boolean read(MemoryBuffer buffer) {
            return buffer.readBoolean();
        }
    }
}

