/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ServerIdleHandler
extends ChannelDuplexHandler {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            try {
                logger.warn("Connection idle, close it from server side: {}", (Object)RemotingUtil.parseRemoteAddress(ctx.channel()));
                ctx.close();
            }
            catch (Exception e) {
                logger.warn("Exception caught when closing connection in ServerIdleHandler.", (Throwable)e);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

