/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.service.rpc.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TSAggregationQueryReq
implements TBase<TSAggregationQueryReq, _Fields>,
Serializable,
Cloneable,
Comparable<TSAggregationQueryReq> {
    private static final TStruct STRUCT_DESC = new TStruct("TSAggregationQueryReq");
    private static final TField SESSION_ID_FIELD_DESC = new TField("sessionId", 10, 1);
    private static final TField STATEMENT_ID_FIELD_DESC = new TField("statementId", 10, 2);
    private static final TField PATHS_FIELD_DESC = new TField("paths", 15, 3);
    private static final TField AGGREGATIONS_FIELD_DESC = new TField("aggregations", 15, 4);
    private static final TField START_TIME_FIELD_DESC = new TField("startTime", 10, 5);
    private static final TField END_TIME_FIELD_DESC = new TField("endTime", 10, 6);
    private static final TField INTERVAL_FIELD_DESC = new TField("interval", 10, 7);
    private static final TField SLIDING_STEP_FIELD_DESC = new TField("slidingStep", 10, 8);
    private static final TField FETCH_SIZE_FIELD_DESC = new TField("fetchSize", 8, 9);
    private static final TField TIMEOUT_FIELD_DESC = new TField("timeout", 10, 10);
    private static final TField LEGAL_PATH_NODES_FIELD_DESC = new TField("legalPathNodes", 2, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSAggregationQueryReqStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSAggregationQueryReqTupleSchemeFactory();
    public long sessionId;
    public long statementId;
    @Nullable
    public List<String> paths;
    @Nullable
    public List<TAggregationType> aggregations;
    public long startTime;
    public long endTime;
    public long interval;
    public long slidingStep;
    public int fetchSize;
    public long timeout;
    public boolean legalPathNodes;
    private static final int __SESSIONID_ISSET_ID = 0;
    private static final int __STATEMENTID_ISSET_ID = 1;
    private static final int __STARTTIME_ISSET_ID = 2;
    private static final int __ENDTIME_ISSET_ID = 3;
    private static final int __INTERVAL_ISSET_ID = 4;
    private static final int __SLIDINGSTEP_ISSET_ID = 5;
    private static final int __FETCHSIZE_ISSET_ID = 6;
    private static final int __TIMEOUT_ISSET_ID = 7;
    private static final int __LEGALPATHNODES_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.START_TIME, _Fields.END_TIME, _Fields.INTERVAL, _Fields.SLIDING_STEP, _Fields.FETCH_SIZE, _Fields.TIMEOUT, _Fields.LEGAL_PATH_NODES};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSAggregationQueryReq() {
    }

    public TSAggregationQueryReq(long sessionId, long statementId, List<String> paths, List<TAggregationType> aggregations) {
        this();
        this.sessionId = sessionId;
        this.setSessionIdIsSet(true);
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        this.paths = paths;
        this.aggregations = aggregations;
    }

    public TSAggregationQueryReq(TSAggregationQueryReq other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.sessionId = other.sessionId;
        this.statementId = other.statementId;
        if (other.isSetPaths()) {
            ArrayList<String> __this__paths = new ArrayList<String>(other.paths);
            this.paths = __this__paths;
        }
        if (other.isSetAggregations()) {
            ArrayList<TAggregationType> __this__aggregations = new ArrayList<TAggregationType>(other.aggregations.size());
            for (TAggregationType other_element : other.aggregations) {
                __this__aggregations.add(other_element);
            }
            this.aggregations = __this__aggregations;
        }
        this.startTime = other.startTime;
        this.endTime = other.endTime;
        this.interval = other.interval;
        this.slidingStep = other.slidingStep;
        this.fetchSize = other.fetchSize;
        this.timeout = other.timeout;
        this.legalPathNodes = other.legalPathNodes;
    }

    public TSAggregationQueryReq deepCopy() {
        return new TSAggregationQueryReq(this);
    }

    public void clear() {
        this.setSessionIdIsSet(false);
        this.sessionId = 0L;
        this.setStatementIdIsSet(false);
        this.statementId = 0L;
        this.paths = null;
        this.aggregations = null;
        this.setStartTimeIsSet(false);
        this.startTime = 0L;
        this.setEndTimeIsSet(false);
        this.endTime = 0L;
        this.setIntervalIsSet(false);
        this.interval = 0L;
        this.setSlidingStepIsSet(false);
        this.slidingStep = 0L;
        this.setFetchSizeIsSet(false);
        this.fetchSize = 0;
        this.setTimeoutIsSet(false);
        this.timeout = 0L;
        this.setLegalPathNodesIsSet(false);
        this.legalPathNodes = false;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public TSAggregationQueryReq setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.setSessionIdIsSet(true);
        return this;
    }

    public void unsetSessionId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetSessionId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setSessionIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getStatementId() {
        return this.statementId;
    }

    public TSAggregationQueryReq setStatementId(long statementId) {
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        return this;
    }

    public void unsetStatementId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetStatementId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setStatementIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getPathsSize() {
        return this.paths == null ? 0 : this.paths.size();
    }

    @Nullable
    public Iterator<String> getPathsIterator() {
        return this.paths == null ? null : this.paths.iterator();
    }

    public void addToPaths(String elem) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(elem);
    }

    @Nullable
    public List<String> getPaths() {
        return this.paths;
    }

    public TSAggregationQueryReq setPaths(@Nullable List<String> paths) {
        this.paths = paths;
        return this;
    }

    public void unsetPaths() {
        this.paths = null;
    }

    public boolean isSetPaths() {
        return this.paths != null;
    }

    public void setPathsIsSet(boolean value) {
        if (!value) {
            this.paths = null;
        }
    }

    public int getAggregationsSize() {
        return this.aggregations == null ? 0 : this.aggregations.size();
    }

    @Nullable
    public Iterator<TAggregationType> getAggregationsIterator() {
        return this.aggregations == null ? null : this.aggregations.iterator();
    }

    public void addToAggregations(TAggregationType elem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<TAggregationType>();
        }
        this.aggregations.add(elem);
    }

    @Nullable
    public List<TAggregationType> getAggregations() {
        return this.aggregations;
    }

    public TSAggregationQueryReq setAggregations(@Nullable List<TAggregationType> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public void unsetAggregations() {
        this.aggregations = null;
    }

    public boolean isSetAggregations() {
        return this.aggregations != null;
    }

    public void setAggregationsIsSet(boolean value) {
        if (!value) {
            this.aggregations = null;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TSAggregationQueryReq setStartTime(long startTime) {
        this.startTime = startTime;
        this.setStartTimeIsSet(true);
        return this;
    }

    public void unsetStartTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetStartTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setStartTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public TSAggregationQueryReq setEndTime(long endTime) {
        this.endTime = endTime;
        this.setEndTimeIsSet(true);
        return this;
    }

    public void unsetEndTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetEndTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setEndTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getInterval() {
        return this.interval;
    }

    public TSAggregationQueryReq setInterval(long interval) {
        this.interval = interval;
        this.setIntervalIsSet(true);
        return this;
    }

    public void unsetInterval() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetInterval() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setIntervalIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public TSAggregationQueryReq setSlidingStep(long slidingStep) {
        this.slidingStep = slidingStep;
        this.setSlidingStepIsSet(true);
        return this;
    }

    public void unsetSlidingStep() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetSlidingStep() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setSlidingStepIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public TSAggregationQueryReq setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        this.setFetchSizeIsSet(true);
        return this;
    }

    public void unsetFetchSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetFetchSize() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setFetchSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TSAggregationQueryReq setTimeout(long timeout) {
        this.timeout = timeout;
        this.setTimeoutIsSet(true);
        return this;
    }

    public void unsetTimeout() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetTimeout() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setTimeoutIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public boolean isLegalPathNodes() {
        return this.legalPathNodes;
    }

    public TSAggregationQueryReq setLegalPathNodes(boolean legalPathNodes) {
        this.legalPathNodes = legalPathNodes;
        this.setLegalPathNodesIsSet(true);
        return this;
    }

    public void unsetLegalPathNodes() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetLegalPathNodes() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setLegalPathNodesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case SESSION_ID: {
                if (value == null) {
                    this.unsetSessionId();
                    break;
                }
                this.setSessionId((Long)value);
                break;
            }
            case STATEMENT_ID: {
                if (value == null) {
                    this.unsetStatementId();
                    break;
                }
                this.setStatementId((Long)value);
                break;
            }
            case PATHS: {
                if (value == null) {
                    this.unsetPaths();
                    break;
                }
                this.setPaths((List)value);
                break;
            }
            case AGGREGATIONS: {
                if (value == null) {
                    this.unsetAggregations();
                    break;
                }
                this.setAggregations((List)value);
                break;
            }
            case START_TIME: {
                if (value == null) {
                    this.unsetStartTime();
                    break;
                }
                this.setStartTime((Long)value);
                break;
            }
            case END_TIME: {
                if (value == null) {
                    this.unsetEndTime();
                    break;
                }
                this.setEndTime((Long)value);
                break;
            }
            case INTERVAL: {
                if (value == null) {
                    this.unsetInterval();
                    break;
                }
                this.setInterval((Long)value);
                break;
            }
            case SLIDING_STEP: {
                if (value == null) {
                    this.unsetSlidingStep();
                    break;
                }
                this.setSlidingStep((Long)value);
                break;
            }
            case FETCH_SIZE: {
                if (value == null) {
                    this.unsetFetchSize();
                    break;
                }
                this.setFetchSize((Integer)value);
                break;
            }
            case TIMEOUT: {
                if (value == null) {
                    this.unsetTimeout();
                    break;
                }
                this.setTimeout((Long)value);
                break;
            }
            case LEGAL_PATH_NODES: {
                if (value == null) {
                    this.unsetLegalPathNodes();
                    break;
                }
                this.setLegalPathNodes((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SESSION_ID: {
                return this.getSessionId();
            }
            case STATEMENT_ID: {
                return this.getStatementId();
            }
            case PATHS: {
                return this.getPaths();
            }
            case AGGREGATIONS: {
                return this.getAggregations();
            }
            case START_TIME: {
                return this.getStartTime();
            }
            case END_TIME: {
                return this.getEndTime();
            }
            case INTERVAL: {
                return this.getInterval();
            }
            case SLIDING_STEP: {
                return this.getSlidingStep();
            }
            case FETCH_SIZE: {
                return this.getFetchSize();
            }
            case TIMEOUT: {
                return this.getTimeout();
            }
            case LEGAL_PATH_NODES: {
                return this.isLegalPathNodes();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SESSION_ID: {
                return this.isSetSessionId();
            }
            case STATEMENT_ID: {
                return this.isSetStatementId();
            }
            case PATHS: {
                return this.isSetPaths();
            }
            case AGGREGATIONS: {
                return this.isSetAggregations();
            }
            case START_TIME: {
                return this.isSetStartTime();
            }
            case END_TIME: {
                return this.isSetEndTime();
            }
            case INTERVAL: {
                return this.isSetInterval();
            }
            case SLIDING_STEP: {
                return this.isSetSlidingStep();
            }
            case FETCH_SIZE: {
                return this.isSetFetchSize();
            }
            case TIMEOUT: {
                return this.isSetTimeout();
            }
            case LEGAL_PATH_NODES: {
                return this.isSetLegalPathNodes();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TSAggregationQueryReq) {
            return this.equals((TSAggregationQueryReq)that);
        }
        return false;
    }

    public boolean equals(TSAggregationQueryReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_sessionId = true;
        boolean that_present_sessionId = true;
        if (this_present_sessionId || that_present_sessionId) {
            if (!this_present_sessionId || !that_present_sessionId) {
                return false;
            }
            if (this.sessionId != that.sessionId) {
                return false;
            }
        }
        boolean this_present_statementId = true;
        boolean that_present_statementId = true;
        if (this_present_statementId || that_present_statementId) {
            if (!this_present_statementId || !that_present_statementId) {
                return false;
            }
            if (this.statementId != that.statementId) {
                return false;
            }
        }
        boolean this_present_paths = this.isSetPaths();
        boolean that_present_paths = that.isSetPaths();
        if (this_present_paths || that_present_paths) {
            if (!this_present_paths || !that_present_paths) {
                return false;
            }
            if (!this.paths.equals(that.paths)) {
                return false;
            }
        }
        boolean this_present_aggregations = this.isSetAggregations();
        boolean that_present_aggregations = that.isSetAggregations();
        if (this_present_aggregations || that_present_aggregations) {
            if (!this_present_aggregations || !that_present_aggregations) {
                return false;
            }
            if (!this.aggregations.equals(that.aggregations)) {
                return false;
            }
        }
        boolean this_present_startTime = this.isSetStartTime();
        boolean that_present_startTime = that.isSetStartTime();
        if (this_present_startTime || that_present_startTime) {
            if (!this_present_startTime || !that_present_startTime) {
                return false;
            }
            if (this.startTime != that.startTime) {
                return false;
            }
        }
        boolean this_present_endTime = this.isSetEndTime();
        boolean that_present_endTime = that.isSetEndTime();
        if (this_present_endTime || that_present_endTime) {
            if (!this_present_endTime || !that_present_endTime) {
                return false;
            }
            if (this.endTime != that.endTime) {
                return false;
            }
        }
        boolean this_present_interval = this.isSetInterval();
        boolean that_present_interval = that.isSetInterval();
        if (this_present_interval || that_present_interval) {
            if (!this_present_interval || !that_present_interval) {
                return false;
            }
            if (this.interval != that.interval) {
                return false;
            }
        }
        boolean this_present_slidingStep = this.isSetSlidingStep();
        boolean that_present_slidingStep = that.isSetSlidingStep();
        if (this_present_slidingStep || that_present_slidingStep) {
            if (!this_present_slidingStep || !that_present_slidingStep) {
                return false;
            }
            if (this.slidingStep != that.slidingStep) {
                return false;
            }
        }
        boolean this_present_fetchSize = this.isSetFetchSize();
        boolean that_present_fetchSize = that.isSetFetchSize();
        if (this_present_fetchSize || that_present_fetchSize) {
            if (!this_present_fetchSize || !that_present_fetchSize) {
                return false;
            }
            if (this.fetchSize != that.fetchSize) {
                return false;
            }
        }
        boolean this_present_timeout = this.isSetTimeout();
        boolean that_present_timeout = that.isSetTimeout();
        if (this_present_timeout || that_present_timeout) {
            if (!this_present_timeout || !that_present_timeout) {
                return false;
            }
            if (this.timeout != that.timeout) {
                return false;
            }
        }
        boolean this_present_legalPathNodes = this.isSetLegalPathNodes();
        boolean that_present_legalPathNodes = that.isSetLegalPathNodes();
        if (this_present_legalPathNodes || that_present_legalPathNodes) {
            if (!this_present_legalPathNodes || !that_present_legalPathNodes) {
                return false;
            }
            if (this.legalPathNodes != that.legalPathNodes) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.sessionId);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.statementId);
        hashCode = hashCode * 8191 + (this.isSetPaths() ? 131071 : 524287);
        if (this.isSetPaths()) {
            hashCode = hashCode * 8191 + this.paths.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAggregations() ? 131071 : 524287);
        if (this.isSetAggregations()) {
            hashCode = hashCode * 8191 + this.aggregations.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStartTime() ? 131071 : 524287);
        if (this.isSetStartTime()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.startTime);
        }
        hashCode = hashCode * 8191 + (this.isSetEndTime() ? 131071 : 524287);
        if (this.isSetEndTime()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.endTime);
        }
        hashCode = hashCode * 8191 + (this.isSetInterval() ? 131071 : 524287);
        if (this.isSetInterval()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.interval);
        }
        hashCode = hashCode * 8191 + (this.isSetSlidingStep() ? 131071 : 524287);
        if (this.isSetSlidingStep()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.slidingStep);
        }
        hashCode = hashCode * 8191 + (this.isSetFetchSize() ? 131071 : 524287);
        if (this.isSetFetchSize()) {
            hashCode = hashCode * 8191 + this.fetchSize;
        }
        hashCode = hashCode * 8191 + (this.isSetTimeout() ? 131071 : 524287);
        if (this.isSetTimeout()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.timeout);
        }
        hashCode = hashCode * 8191 + (this.isSetLegalPathNodes() ? 131071 : 524287);
        if (this.isSetLegalPathNodes()) {
            hashCode = hashCode * 8191 + (this.legalPathNodes ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSAggregationQueryReq other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetSessionId(), other.isSetSessionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSessionId() && (lastComparison = TBaseHelper.compareTo((long)this.sessionId, (long)other.sessionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStatementId(), other.isSetStatementId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatementId() && (lastComparison = TBaseHelper.compareTo((long)this.statementId, (long)other.statementId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPaths(), other.isSetPaths());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPaths() && (lastComparison = TBaseHelper.compareTo(this.paths, other.paths)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAggregations(), other.isSetAggregations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggregations() && (lastComparison = TBaseHelper.compareTo(this.aggregations, other.aggregations)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStartTime(), other.isSetStartTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartTime() && (lastComparison = TBaseHelper.compareTo((long)this.startTime, (long)other.startTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEndTime(), other.isSetEndTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEndTime() && (lastComparison = TBaseHelper.compareTo((long)this.endTime, (long)other.endTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetInterval(), other.isSetInterval());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInterval() && (lastComparison = TBaseHelper.compareTo((long)this.interval, (long)other.interval)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSlidingStep(), other.isSetSlidingStep());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSlidingStep() && (lastComparison = TBaseHelper.compareTo((long)this.slidingStep, (long)other.slidingStep)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFetchSize(), other.isSetFetchSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFetchSize() && (lastComparison = TBaseHelper.compareTo((int)this.fetchSize, (int)other.fetchSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeout(), other.isSetTimeout());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeout() && (lastComparison = TBaseHelper.compareTo((long)this.timeout, (long)other.timeout)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLegalPathNodes(), other.isSetLegalPathNodes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLegalPathNodes() && (lastComparison = TBaseHelper.compareTo((boolean)this.legalPathNodes, (boolean)other.legalPathNodes)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TSAggregationQueryReq.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TSAggregationQueryReq.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSAggregationQueryReq(");
        boolean first = true;
        sb.append("sessionId:");
        sb.append(this.sessionId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("statementId:");
        sb.append(this.statementId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("paths:");
        if (this.paths == null) {
            sb.append("null");
        } else {
            sb.append(this.paths);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("aggregations:");
        if (this.aggregations == null) {
            sb.append("null");
        } else {
            sb.append(this.aggregations);
        }
        first = false;
        if (this.isSetStartTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("startTime:");
            sb.append(this.startTime);
            first = false;
        }
        if (this.isSetEndTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("endTime:");
            sb.append(this.endTime);
            first = false;
        }
        if (this.isSetInterval()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("interval:");
            sb.append(this.interval);
            first = false;
        }
        if (this.isSetSlidingStep()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("slidingStep:");
            sb.append(this.slidingStep);
            first = false;
        }
        if (this.isSetFetchSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fetchSize:");
            sb.append(this.fetchSize);
            first = false;
        }
        if (this.isSetTimeout()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeout:");
            sb.append(this.timeout);
            first = false;
        }
        if (this.isSetLegalPathNodes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("legalPathNodes:");
            sb.append(this.legalPathNodes);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.paths == null) {
            throw new TProtocolException("Required field 'paths' was not present! Struct: " + this.toString());
        }
        if (this.aggregations == null) {
            throw new TProtocolException("Required field 'aggregations' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SESSION_ID, new FieldMetaData("sessionId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STATEMENT_ID, new FieldMetaData("statementId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PATHS, new FieldMetaData("paths", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.AGGREGATIONS, new FieldMetaData("aggregations", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new EnumMetaData(16, TAggregationType.class))));
        tmpMap.put(_Fields.START_TIME, new FieldMetaData("startTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.END_TIME, new FieldMetaData("endTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INTERVAL, new FieldMetaData("interval", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SLIDING_STEP, new FieldMetaData("slidingStep", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FETCH_SIZE, new FieldMetaData("fetchSize", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.TIMEOUT, new FieldMetaData("timeout", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.LEGAL_PATH_NODES, new FieldMetaData("legalPathNodes", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSAggregationQueryReq.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SESSION_ID(1, "sessionId"),
        STATEMENT_ID(2, "statementId"),
        PATHS(3, "paths"),
        AGGREGATIONS(4, "aggregations"),
        START_TIME(5, "startTime"),
        END_TIME(6, "endTime"),
        INTERVAL(7, "interval"),
        SLIDING_STEP(8, "slidingStep"),
        FETCH_SIZE(9, "fetchSize"),
        TIMEOUT(10, "timeout"),
        LEGAL_PATH_NODES(11, "legalPathNodes");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SESSION_ID;
                }
                case 2: {
                    return STATEMENT_ID;
                }
                case 3: {
                    return PATHS;
                }
                case 4: {
                    return AGGREGATIONS;
                }
                case 5: {
                    return START_TIME;
                }
                case 6: {
                    return END_TIME;
                }
                case 7: {
                    return INTERVAL;
                }
                case 8: {
                    return SLIDING_STEP;
                }
                case 9: {
                    return FETCH_SIZE;
                }
                case 10: {
                    return TIMEOUT;
                }
                case 11: {
                    return LEGAL_PATH_NODES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TSAggregationQueryReqStandardSchemeFactory
    implements SchemeFactory {
        private TSAggregationQueryReqStandardSchemeFactory() {
        }

        public TSAggregationQueryReqStandardScheme getScheme() {
            return new TSAggregationQueryReqStandardScheme();
        }
    }

    private static class TSAggregationQueryReqTupleSchemeFactory
    implements SchemeFactory {
        private TSAggregationQueryReqTupleSchemeFactory() {
        }

        public TSAggregationQueryReqTupleScheme getScheme() {
            return new TSAggregationQueryReqTupleScheme();
        }
    }

    private static class TSAggregationQueryReqTupleScheme
    extends TupleScheme<TSAggregationQueryReq> {
        private TSAggregationQueryReqTupleScheme() {
        }

        public void write(TProtocol prot, TSAggregationQueryReq struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.sessionId);
            oprot.writeI64(struct.statementId);
            oprot.writeI32(struct.paths.size());
            for (String _iter592 : struct.paths) {
                oprot.writeString(_iter592);
            }
            oprot.writeI32(struct.aggregations.size());
            for (TAggregationType _iter593 : struct.aggregations) {
                oprot.writeI32(_iter593.getValue());
            }
            BitSet optionals = new BitSet();
            if (struct.isSetStartTime()) {
                optionals.set(0);
            }
            if (struct.isSetEndTime()) {
                optionals.set(1);
            }
            if (struct.isSetInterval()) {
                optionals.set(2);
            }
            if (struct.isSetSlidingStep()) {
                optionals.set(3);
            }
            if (struct.isSetFetchSize()) {
                optionals.set(4);
            }
            if (struct.isSetTimeout()) {
                optionals.set(5);
            }
            if (struct.isSetLegalPathNodes()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetStartTime()) {
                oprot.writeI64(struct.startTime);
            }
            if (struct.isSetEndTime()) {
                oprot.writeI64(struct.endTime);
            }
            if (struct.isSetInterval()) {
                oprot.writeI64(struct.interval);
            }
            if (struct.isSetSlidingStep()) {
                oprot.writeI64(struct.slidingStep);
            }
            if (struct.isSetFetchSize()) {
                oprot.writeI32(struct.fetchSize);
            }
            if (struct.isSetTimeout()) {
                oprot.writeI64(struct.timeout);
            }
            if (struct.isSetLegalPathNodes()) {
                oprot.writeBool(struct.legalPathNodes);
            }
        }

        public void read(TProtocol prot, TSAggregationQueryReq struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.sessionId = iprot.readI64();
            struct.setSessionIdIsSet(true);
            struct.statementId = iprot.readI64();
            struct.setStatementIdIsSet(true);
            TList _list594 = iprot.readListBegin((byte)11);
            struct.paths = new ArrayList<String>(_list594.size);
            for (int _i596 = 0; _i596 < _list594.size; ++_i596) {
                String _elem595 = iprot.readString();
                struct.paths.add(_elem595);
            }
            struct.setPathsIsSet(true);
            TList _list597 = iprot.readListBegin((byte)8);
            struct.aggregations = new ArrayList<TAggregationType>(_list597.size);
            for (int _i599 = 0; _i599 < _list597.size; ++_i599) {
                TAggregationType _elem598 = TAggregationType.findByValue((int)iprot.readI32());
                if (_elem598 == null) continue;
                struct.aggregations.add(_elem598);
            }
            struct.setAggregationsIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.startTime = iprot.readI64();
                struct.setStartTimeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.endTime = iprot.readI64();
                struct.setEndTimeIsSet(true);
            }
            if (incoming.get(2)) {
                struct.interval = iprot.readI64();
                struct.setIntervalIsSet(true);
            }
            if (incoming.get(3)) {
                struct.slidingStep = iprot.readI64();
                struct.setSlidingStepIsSet(true);
            }
            if (incoming.get(4)) {
                struct.fetchSize = iprot.readI32();
                struct.setFetchSizeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.timeout = iprot.readI64();
                struct.setTimeoutIsSet(true);
            }
            if (incoming.get(6)) {
                struct.legalPathNodes = iprot.readBool();
                struct.setLegalPathNodesIsSet(true);
            }
        }
    }

    private static class TSAggregationQueryReqStandardScheme
    extends StandardScheme<TSAggregationQueryReq> {
        private TSAggregationQueryReqStandardScheme() {
        }

        public void read(TProtocol iprot, TSAggregationQueryReq struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.sessionId = iprot.readI64();
                            struct.setSessionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.statementId = iprot.readI64();
                            struct.setStatementIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list584 = iprot.readListBegin();
                            struct.paths = new ArrayList<String>(_list584.size);
                            for (int _i586 = 0; _i586 < _list584.size; ++_i586) {
                                String _elem585 = iprot.readString();
                                struct.paths.add(_elem585);
                            }
                            iprot.readListEnd();
                            struct.setPathsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list587 = iprot.readListBegin();
                            struct.aggregations = new ArrayList<TAggregationType>(_list587.size);
                            for (int _i589 = 0; _i589 < _list587.size; ++_i589) {
                                TAggregationType _elem588 = TAggregationType.findByValue((int)iprot.readI32());
                                if (_elem588 == null) continue;
                                struct.aggregations.add(_elem588);
                            }
                            iprot.readListEnd();
                            struct.setAggregationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.startTime = iprot.readI64();
                            struct.setStartTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.endTime = iprot.readI64();
                            struct.setEndTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.interval = iprot.readI64();
                            struct.setIntervalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.slidingStep = iprot.readI64();
                            struct.setSlidingStepIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.fetchSize = iprot.readI32();
                            struct.setFetchSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.timeout = iprot.readI64();
                            struct.setTimeoutIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.legalPathNodes = iprot.readBool();
                            struct.setLegalPathNodesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetSessionId()) {
                throw new TProtocolException("Required field 'sessionId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetStatementId()) {
                throw new TProtocolException("Required field 'statementId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TSAggregationQueryReq struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(SESSION_ID_FIELD_DESC);
            oprot.writeI64(struct.sessionId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(STATEMENT_ID_FIELD_DESC);
            oprot.writeI64(struct.statementId);
            oprot.writeFieldEnd();
            if (struct.paths != null) {
                oprot.writeFieldBegin(PATHS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.paths.size()));
                for (String _iter590 : struct.paths) {
                    oprot.writeString(_iter590);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.aggregations != null) {
                oprot.writeFieldBegin(AGGREGATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.aggregations.size()));
                for (TAggregationType _iter591 : struct.aggregations) {
                    oprot.writeI32(_iter591.getValue());
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetStartTime()) {
                oprot.writeFieldBegin(START_TIME_FIELD_DESC);
                oprot.writeI64(struct.startTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetEndTime()) {
                oprot.writeFieldBegin(END_TIME_FIELD_DESC);
                oprot.writeI64(struct.endTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetInterval()) {
                oprot.writeFieldBegin(INTERVAL_FIELD_DESC);
                oprot.writeI64(struct.interval);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSlidingStep()) {
                oprot.writeFieldBegin(SLIDING_STEP_FIELD_DESC);
                oprot.writeI64(struct.slidingStep);
                oprot.writeFieldEnd();
            }
            if (struct.isSetFetchSize()) {
                oprot.writeFieldBegin(FETCH_SIZE_FIELD_DESC);
                oprot.writeI32(struct.fetchSize);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeout()) {
                oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
                oprot.writeI64(struct.timeout);
                oprot.writeFieldEnd();
            }
            if (struct.isSetLegalPathNodes()) {
                oprot.writeFieldBegin(LEGAL_PATH_NODES_FIELD_DESC);
                oprot.writeBool(struct.legalPathNodes);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

