/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.headers;

import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.UaException;

public interface HeaderDecoder {
    public static final long PROTOCOL_VERSION = 0L;
    public static final int HEADER_LENGTH = 8;
    public static final int HEADER_LENGTH_INDEX = 4;

    default public int getMessageLength(ByteBuf buffer, int maxMessageLength) throws UaException {
        long messageLength = buffer.getUnsignedIntLE(buffer.readerIndex() + 4);
        if (messageLength <= (long)maxMessageLength) {
            return (int)messageLength;
        }
        throw new UaException(0x80800000L, String.format("max message length exceeded (%s > %s)", messageLength, maxMessageLength));
    }
}

